/*
 * Decompiled with CFR 0.152.
 */
package coco4j;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;

public class BoundedVirtualThreadPerTaskExecutor
implements ExecutorService {
    private final ExecutorService executor;
    private final Semaphore semaphore;

    public BoundedVirtualThreadPerTaskExecutor(int parallelism) {
        this(parallelism, null, null, null);
    }

    public BoundedVirtualThreadPerTaskExecutor(int parallelism, String name) {
        this(parallelism, name, null, null);
    }

    public BoundedVirtualThreadPerTaskExecutor(int parallelism, String prefix, long start) {
        this(parallelism, null, prefix, start);
    }

    private BoundedVirtualThreadPerTaskExecutor(int parallelism, String name, String prefix, Long start) {
        BoundedVirtualThreadPerTaskExecutor.requirePositive(parallelism);
        this.semaphore = new Semaphore(parallelism, true);
        this.executor = Executors.newThreadPerTaskExecutor(BoundedVirtualThreadPerTaskExecutor.getVirtualThreadFactory(name, prefix, start));
    }

    private static ThreadFactory getVirtualThreadFactory(String name, String prefix, Long start) {
        BoundedVirtualThreadPerTaskExecutor.validateThreadFactoryParameters(name, prefix, start);
        return BoundedVirtualThreadPerTaskExecutor.createVirtualThreadFactory(name, prefix, start);
    }

    private static void validateThreadFactoryParameters(String name, String prefix, Long start) {
        if (name != null && (prefix != null || start != null)) {
            throw new IllegalArgumentException("Cannot specify both name and prefix/start for virtual thread factory");
        }
        if (prefix == null && start != null) {
            throw new IllegalArgumentException("Must specify thread name prefix together with counter start for virtual thread factory");
        }
        if (prefix != null && start == null) {
            throw new IllegalArgumentException("Must specify counter start together with thread name prefix for virtual thread factory");
        }
    }

    private static ThreadFactory createVirtualThreadFactory(String name, String prefix, Long start) {
        Thread.Builder.OfVirtual builder = Thread.ofVirtual();
        if (name != null) {
            return builder.name(name).factory();
        }
        if (prefix != null) {
            return builder.name(prefix, start).factory();
        }
        return builder.factory();
    }

    private static void requirePositive(int parallelism) {
        if (parallelism <= 0) {
            throw new IllegalArgumentException("parallelism must be positive but was " + parallelism);
        }
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    @NonNull
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    @NonNull
    public <T> Future<T> submit(@NonNull Callable<T> task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        this.semaphore.acquire();
        try {
            Future<T> future = this.executor.submit(task);
            this.semaphore.release();
            return future;
        }
        catch (Throwable throwable) {
            try {
                this.semaphore.release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CompletionException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <T> Future<T> submit(@NonNull Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        this.semaphore.acquire();
        try {
            Future<T> future = this.executor.submit(task, result);
            this.semaphore.release();
            return future;
        }
        catch (Throwable throwable) {
            try {
                this.semaphore.release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CompletionException(e);
            }
        }
    }

    @Override
    @NonNull
    public Future<?> submit(@NonNull Runnable task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        this.semaphore.acquire();
        try {
            Future<?> future = this.executor.submit(task);
            this.semaphore.release();
            return future;
        }
        catch (Throwable throwable) {
            try {
                this.semaphore.release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CompletionException(e);
            }
        }
    }

    @Override
    @NonNull
    public <T> List<Future<T>> invokeAll(@NonNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        this.semaphore.acquire();
        try {
            List list = this.executor.invokeAll(tasks);
            return list;
        }
        finally {
            this.semaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <T> List<Future<T>> invokeAll(@NonNull Collection<? extends Callable<T>> tasks, long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.semaphore.acquire();
        try {
            List list = this.executor.invokeAll(tasks, timeout, unit);
            return list;
        }
        finally {
            this.semaphore.release();
        }
    }

    @Override
    @NonNull
    public <T> T invokeAny(@NonNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        this.semaphore.acquire();
        try {
            Object t = this.executor.invokeAny(tasks);
            return t;
        }
        finally {
            this.semaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAny(@NonNull Collection<? extends Callable<T>> tasks, long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.semaphore.acquire();
        try {
            Object t = this.executor.invokeAny(tasks, timeout, unit);
            return t;
        }
        finally {
            this.semaphore.release();
        }
    }

    @Override
    public void execute(@NonNull Runnable command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        try {
            this.semaphore.acquire();
            try {
                this.executor.execute(command);
            }
            finally {
                this.semaphore.release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CompletionException(e);
        }
    }
}

