/*
 * Decompiled with CFR 0.152.
 */
package coco4j;

import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import lombok.NonNull;

public class Futures {
    private Futures() {
    }

    public static <T> T getOrThrowUncheckable(@NonNull Future<T> future) {
        if (future == null) {
            throw new NullPointerException("future is marked non-null but is null");
        }
        return future.get();
    }

    public static <T> T getOrThrowUnchecked(@NonNull Future<T> future) {
        if (future == null) {
            throw new NullPointerException("future is marked non-null but is null");
        }
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CompletionException(e);
        }
        catch (ExecutionException e) {
            throw new CompletionException(e);
        }
    }
}

