/*
 * Decompiled with CFR 0.152.
 */
package coco4j;

import coco4j.BoundedVirtualThreadPerTaskExecutor;
import coco4j.RejectedExecutionHandlers;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class MoreExecutors {
    private MoreExecutors() {
    }

    @NonNull
    public static ThreadPoolExecutor newSinglePlatformThreadBlockingResubmitExecutor() {
        return MoreExecutors.newSinglePlatformThreadBlockingResubmitExecutor(Integer.MAX_VALUE);
    }

    @NonNull
    public static ThreadPoolExecutor newSinglePlatformThreadBlockingResubmitExecutor(int workQueueCapacity) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(workQueueCapacity), RejectedExecutionHandlers.blockingResubmitPolicy());
    }

    @NonNull
    public static ExecutorService newBoundedVirtualThreadPerTaskExecutor(int parallelism) {
        return new BoundedVirtualThreadPerTaskExecutor(parallelism);
    }

    @NonNull
    public static ExecutorService newBoundedVirtualThreadPerTaskExecutor(int parallelism, String threadName) {
        return new BoundedVirtualThreadPerTaskExecutor(parallelism, threadName);
    }

    @NonNull
    public static ExecutorService newBoundedVirtualThreadPerTaskExecutor(int parallelism, String prefix, long start) {
        return new BoundedVirtualThreadPerTaskExecutor(parallelism, prefix, start);
    }

    @NonNull
    public static ExecutorService newSingleVirtualThreadExecutor() {
        return Executors.newSingleThreadExecutor(Thread.ofVirtual().factory());
    }

    @NonNull
    public static ExecutorService newSingleVirtualThreadExecutor(String name) {
        return Executors.newSingleThreadExecutor(Thread.ofVirtual().name(name).factory());
    }

    @NonNull
    public static ExecutorService newSingleVirtualThreadExecutor(String prefix, long start) {
        return Executors.newSingleThreadExecutor(Thread.ofVirtual().name(prefix, start).factory());
    }

    @NonNull
    public static ExecutorService newVirtualThreadPerTaskExecutor(String threadName) {
        return Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name(threadName).factory());
    }

    @NonNull
    public static ExecutorService newVirtualThreadPerTaskExecutor(String prefix, long start) {
        return Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name(prefix, start).factory());
    }
}

