/*
 * Decompiled with CFR 0.152.
 */
package coco4j;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.NonNull;

public class ThreadFactories {
    private ThreadFactories() {
    }

    @NonNull
    public static ThreadFactory newPlatformThreadFactory(@NonNull String threadNamePrefix) {
        if (threadNamePrefix == null) {
            throw new NullPointerException("threadNamePrefix is marked non-null but is null");
        }
        ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
        return runnable -> {
            Thread t = defaultThreadFactory.newThread(runnable);
            t.setName(String.join((CharSequence)"-", threadNamePrefix, t.getName()));
            return t;
        };
    }
}

