/*
 * Decompiled with CFR 0.152.
 */
package coco4j;

import java.time.Duration;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class Threads {
    private Threads() {
    }

    public static void sleepUnchecked(@NonNull Duration duration) {
        if (duration == null) {
            throw new NullPointerException("duration is marked non-null but is null");
        }
        try {
            TimeUnit.NANOSECONDS.sleep(duration.toNanos());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CompletionException(e);
        }
    }

    public static void sleepUncheckable(@NonNull Duration duration) {
        if (duration == null) {
            throw new NullPointerException("duration is marked non-null but is null");
        }
        TimeUnit.NANOSECONDS.sleep(duration.toNanos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleepUninterruptiblyUnchecked(@NonNull Duration duration) {
        if (duration == null) {
            throw new NullPointerException("duration is marked non-null but is null");
        }
        InterruptedException interrupted = null;
        try {
            long remainingNanos = duration.toNanos();
            long end = System.nanoTime() + remainingNanos;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(remainingNanos);
                }
                catch (InterruptedException e) {
                    interrupted = e;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
            if (interrupted != null) {
                throw new CompletionException(interrupted);
            }
        }
        finally {
            if (interrupted != null) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleepUninterruptiblyUncheckable(@NonNull Duration duration) {
        if (duration == null) {
            throw new NullPointerException("duration is marked non-null but is null");
        }
        InterruptedException interrupted = null;
        try {
            long remainingNanos = duration.toNanos();
            long end = System.nanoTime() + remainingNanos;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(remainingNanos);
                }
                catch (InterruptedException e) {
                    interrupted = e;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
            if (interrupted != null) {
                throw interrupted;
            }
        }
        finally {
            if (interrupted != null) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

