/*
 * Decompiled with CFR 0.152.
 */
package conseq4j.execute;

import conseq4j.execute.SequentialExecutor;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;

@ThreadSafe
public final class ConseqExecutor
implements SequentialExecutor {
    private static final int DEFAULT_CONCURRENCY = Math.max(16, Runtime.getRuntime().availableProcessors());
    private static final int DEFAULT_WORK_QUEUE_CAPACITY = Integer.MAX_VALUE;
    private static final ThreadPoolExecutor.AbortPolicy DEFAULT_REJECTED_HANDLER = new ThreadPoolExecutor.AbortPolicy();
    private static final Builder.WorkQueueType DEFAULT_WORK_QUEUE_TYPE = Builder.WorkQueueType.LINKED;
    private final Map<Object, CompletableFuture<?>> sequentialExecutors = new ConcurrentHashMap();
    private final ExecutorService adminThreadPool = Executors.newCachedThreadPool();
    private final ExecutorService workerThreadPool;

    private ConseqExecutor(@Nonnull Builder builder) {
        this(new ThreadPoolExecutor(builder.concurrency, builder.concurrency, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)(builder.workQueueType == Builder.WorkQueueType.ARRAY ? new ArrayBlockingQueue(builder.workQueueCapacity) : new LinkedBlockingQueue(builder.workQueueCapacity))), Executors.defaultThreadFactory(), builder.rejectedExecutionHandler));
    }

    private ConseqExecutor(ExecutorService workerThreadPool) {
        this.workerThreadPool = workerThreadPool;
    }

    @Nonnull
    public static ConseqExecutor newInstance() {
        return new Builder().build();
    }

    @Nonnull
    public static ConseqExecutor newInstance(int concurrency) {
        return new Builder().concurrency(concurrency).build();
    }

    public static ConseqExecutor from(ExecutorService workerThreadPool) {
        return new ConseqExecutor(workerThreadPool);
    }

    private static <T> T call(Callable<T> task) {
        try {
            return task.call();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    public CompletableFuture<Void> execute(@NonNull Runnable command, @NonNull Object sequenceKey) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (sequenceKey == null) {
            throw new NullPointerException("sequenceKey is marked non-null but is null");
        }
        return this.submit(Executors.callable(command, null), sequenceKey);
    }

    public <T> CompletableFuture<T> submit(@NonNull Callable<T> task, @NonNull Object sequenceKey) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (sequenceKey == null) {
            throw new NullPointerException("sequenceKey is marked non-null but is null");
        }
        CompletableFuture taskFifoQueueTail = this.sequentialExecutors.compute(sequenceKey, (k, presentTail) -> presentTail == null ? CompletableFuture.supplyAsync(() -> ConseqExecutor.call(task), this.workerThreadPool) : presentTail.handleAsync((r, e) -> ConseqExecutor.call(task), (Executor)this.workerThreadPool));
        taskFifoQueueTail.whenCompleteAsync((r, e) -> this.sequentialExecutors.computeIfPresent(sequenceKey, (k, checkedTaskFifoQueueTail) -> checkedTaskFifoQueueTail.isDone() ? null : checkedTaskFifoQueueTail), (Executor)this.adminThreadPool);
        return taskFifoQueueTail.thenApply(r -> r);
    }

    @Override
    public void shutdown() {
        ExecutorService shutdownThread = Executors.newSingleThreadExecutor();
        shutdownThread.execute(() -> {
            this.workerThreadPool.shutdown();
            while (true) {
                try {
                    while (!this.workerThreadPool.awaitTermination(5L, TimeUnit.MINUTES)) {
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            this.adminThreadPool.shutdown();
        });
        shutdownThread.shutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.workerThreadPool.isTerminated() && this.adminThreadPool.isTerminated();
    }

    int estimateActiveExecutorCount() {
        return this.sequentialExecutors.size();
    }

    public String toString() {
        return "ConseqExecutor(sequentialExecutors=" + this.sequentialExecutors + ", adminThreadPool=" + this.adminThreadPool + ", workerThreadPool=" + this.workerThreadPool + ")";
    }

    static /* synthetic */ int access$400() {
        return DEFAULT_CONCURRENCY;
    }

    static /* synthetic */ ThreadPoolExecutor.AbortPolicy access$500() {
        return DEFAULT_REJECTED_HANDLER;
    }

    public static final class Builder {
        private int concurrency = ConseqExecutor.access$400();
        private int workQueueCapacity = Integer.MAX_VALUE;
        private WorkQueueType workQueueType;
        private RejectedExecutionHandler rejectedExecutionHandler = ConseqExecutor.access$500();

        public Builder() {
            this.workQueueType = DEFAULT_WORK_QUEUE_TYPE;
        }

        public Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public Builder workQueueCapacity(int workQueueCapacity) {
            this.workQueueCapacity = workQueueCapacity;
            return this;
        }

        public Builder rejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
            this.rejectedExecutionHandler = rejectedExecutionHandler;
            return this;
        }

        @Nonnull
        public ConseqExecutor build() {
            return new ConseqExecutor(this);
        }

        public Builder workQueueType(WorkQueueType workQueueType) {
            this.workQueueType = workQueueType;
            return this;
        }

        public static enum WorkQueueType {
            LINKED,
            ARRAY;

        }
    }
}

