/*
 * Decompiled with CFR 0.152.
 */
package conseq4j.summon;

import conseq4j.summon.SequentialExecutorServiceFactory;
import conseq4j.summon.ShutdownDisabledExecutorService;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ConseqServiceFactory
implements SequentialExecutorServiceFactory {
    private static final int DEFAULT_CONCURRENCY = Math.max(16, Runtime.getRuntime().availableProcessors());
    private final int concurrency;
    private final ConcurrentMap<Object, ExecutorService> sequentialExecutors;

    private ConseqServiceFactory(int concurrency) {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("expecting positive concurrency, but given: " + concurrency);
        }
        this.concurrency = concurrency;
        this.sequentialExecutors = new ConcurrentHashMap<Object, ExecutorService>(concurrency);
    }

    public static ConseqServiceFactory newInstance() {
        return new ConseqServiceFactory(DEFAULT_CONCURRENCY);
    }

    public static ConseqServiceFactory newInstance(int concurrency) {
        return new ConseqServiceFactory(concurrency);
    }

    @Override
    public ExecutorService getExecutorService(Object sequenceKey) {
        return this.sequentialExecutors.computeIfAbsent(this.bucketOf(sequenceKey), bucket -> new ShutdownDisabledExecutorService(Executors.newSingleThreadExecutor()));
    }

    @Override
    public void shutdown() {
        this.sequentialExecutors.values().parallelStream().forEach(ExecutorService::shutdown);
    }

    @Override
    public boolean isTerminated() {
        return this.sequentialExecutors.values().parallelStream().allMatch(ExecutorService::isTerminated);
    }

    private int bucketOf(Object sequenceKey) {
        return Math.floorMod(Objects.hash(sequenceKey), this.concurrency);
    }

    public String toString() {
        return "ConseqServiceFactory(concurrency=" + this.concurrency + ", sequentialExecutors=" + this.sequentialExecutors + ")";
    }
}

