/*
 * Decompiled with CFR 0.152.
 */
package conseq4j.summon;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class ShutdownDisabledExecutorService
implements ExecutorService {
    private static final String SHUTDOWN_UNSUPPORTED_MESSAGE = "Shutdown not supported: Tasks being executed by this service may be from unrelated owners; shutdown features are disabled to prevent undesired task cancellation on other owners";
    private final ExecutorService delegate;

    public ShutdownDisabledExecutorService(ExecutorService delegate) {
        this.delegate = delegate;
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException(SHUTDOWN_UNSUPPORTED_MESSAGE);
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException(SHUTDOWN_UNSUPPORTED_MESSAGE);
    }

    public String toString() {
        return "ShutdownDisabledExecutorService(delegate=" + this.delegate + ")";
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long arg0, TimeUnit arg1) throws InterruptedException {
        return this.delegate.awaitTermination(arg0, arg1);
    }

    @Override
    public <T> Future<T> submit(Callable<T> arg0) {
        return this.delegate.submit(arg0);
    }

    @Override
    public <T> Future<T> submit(Runnable arg0, T arg1) {
        return this.delegate.submit(arg0, arg1);
    }

    @Override
    public Future<?> submit(Runnable arg0) {
        return this.delegate.submit(arg0);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> arg0) throws InterruptedException {
        return this.delegate.invokeAll(arg0);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException {
        return this.delegate.invokeAll(arg0, arg1, arg2);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> arg0) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(arg0);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(arg0, arg1, arg2);
    }

    @Override
    public void execute(Runnable arg0) {
        this.delegate.execute(arg0);
    }

    private static interface ShutdownOperations {
        public void shutdown();

        public List<Runnable> shutdownNow();
    }
}

