/*
 * Decompiled with CFR 0.152.
 */
package conseq4j.util;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

public class MoreRejectedExecutionHandlers {
    private MoreRejectedExecutionHandlers() {
    }

    public static RejectedExecutionHandler blockingRetryPolicy() {
        return new BlockingRetryPolicy();
    }

    private static class BlockingRetryPolicy
    implements RejectedExecutionHandler {
        private BlockingRetryPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isTerminated()) {
                return;
            }
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

