/*
 * Decompiled with CFR 0.152.
 */
package conseq4j.summon;

import conseq4j.Terminable;
import conseq4j.summon.SequentialExecutorServiceFactory;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;

@ThreadSafe
public final class ConseqServiceFactory
implements SequentialExecutorServiceFactory,
Terminable,
AutoCloseable {
    private final int concurrency;
    private final ConcurrentMap<Object, ShutdownDisabledExecutorService> sequentialExecutors;

    private ConseqServiceFactory(int concurrency) {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("expecting positive concurrency, but given: " + concurrency);
        }
        this.concurrency = concurrency;
        this.sequentialExecutors = new ConcurrentHashMap<Object, ShutdownDisabledExecutorService>(concurrency);
    }

    @Nonnull
    public static ConseqServiceFactory instance() {
        return ConseqServiceFactory.instance(Runtime.getRuntime().availableProcessors());
    }

    @Nonnull
    public static ConseqServiceFactory instance(int concurrency) {
        return new ConseqServiceFactory(concurrency);
    }

    private static ConditionFactory awaitForever() {
        return Awaitility.await().forever().pollDelay(Duration.ofMillis(10L));
    }

    @Override
    public ExecutorService getExecutorService(@NonNull Object sequenceKey) {
        if (sequenceKey == null) {
            throw new NullPointerException("sequenceKey is marked non-null but is null");
        }
        return this.sequentialExecutors.computeIfAbsent(this.bucketOf(sequenceKey), bucket -> new ShutdownDisabledExecutorService(Executors.newSingleThreadExecutor()));
    }

    @Override
    public void close() {
        this.sequentialExecutors.values().forEach(ShutdownDisabledExecutorService::shutdownDelegate);
        ConseqServiceFactory.awaitForever().until(this::isTerminated);
    }

    private int bucketOf(Object sequenceKey) {
        return Math.floorMod(Objects.hash(sequenceKey), this.concurrency);
    }

    @Override
    public void terminate() {
        this.sequentialExecutors.values().parallelStream().forEach(ShutdownDisabledExecutorService::shutdownDelegate);
    }

    @Override
    public boolean isTerminated() {
        return this.sequentialExecutors.values().stream().allMatch(ExecutorService::isTerminated);
    }

    @Override
    public List<Runnable> terminateNow() {
        return this.sequentialExecutors.values().parallelStream().map(ShutdownDisabledExecutorService::shutdownDelegateNow).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String toString() {
        return "ConseqServiceFactory(concurrency=" + this.concurrency + ", sequentialExecutors=" + this.sequentialExecutors + ")";
    }

    static final class ShutdownDisabledExecutorService
    implements ExecutorService {
        private static final String SHUTDOWN_UNSUPPORTED_MESSAGE = "Shutdown not supported: Tasks being executed by this service may be from unrelated owners; shutdown features are disabled to prevent undesired task cancellation on other owners";
        private final ExecutorService delegate;

        public ShutdownDisabledExecutorService(ExecutorService delegate) {
            this.delegate = delegate;
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException(SHUTDOWN_UNSUPPORTED_MESSAGE);
        }

        @Override
        @Nonnull
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException(SHUTDOWN_UNSUPPORTED_MESSAGE);
        }

        void shutdownDelegate() {
            this.delegate.shutdown();
        }

        @Nonnull
        List<Runnable> shutdownDelegateNow() {
            return this.delegate.shutdownNow();
        }

        public String toString() {
            return "ConseqServiceFactory.ShutdownDisabledExecutorService(delegate=" + this.delegate + ")";
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public boolean awaitTermination(long arg0, TimeUnit arg1) throws InterruptedException {
            return this.delegate.awaitTermination(arg0, arg1);
        }

        @Override
        public <T> Future<T> submit(Callable<T> arg0) {
            return this.delegate.submit(arg0);
        }

        @Override
        public <T> Future<T> submit(Runnable arg0, T arg1) {
            return this.delegate.submit(arg0, arg1);
        }

        @Override
        public Future<?> submit(Runnable arg0) {
            return this.delegate.submit(arg0);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> arg0) throws InterruptedException {
            return this.delegate.invokeAll(arg0);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException {
            return this.delegate.invokeAll(arg0, arg1, arg2);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> arg0) throws InterruptedException, ExecutionException {
            return this.delegate.invokeAny(arg0);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.invokeAny(arg0, arg1, arg2);
        }

        @Override
        public void execute(Runnable arg0) {
            this.delegate.execute(arg0);
        }

        private static interface ShutdownOperations {
            public void shutdown();

            public List<Runnable> shutdownNow();

            public void close();
        }
    }
}

