/*
 * Decompiled with CFR 0.152.
 */
package q3769.maven.plugins.semver;

import com.github.zafarkhaja.semver.Version;
import javax.annotation.Nonnull;
import lombok.NonNull;

public enum NormalVersion {
    MAJOR{

        @Override
        public long getNumber(Version semver) {
            return semver.majorVersion();
        }

        @Override
        public Version incrementTo(long target, Version semver) {
            if (semver.majorVersion() >= target) {
                throw NormalVersion.newIllegalIncrementError(this, target, semver);
            }
            return Version.of((long)target);
        }
    }
    ,
    MINOR{

        @Override
        public long getNumber(Version semver) {
            return semver.minorVersion();
        }

        @Override
        public Version incrementTo(long target, Version semver) {
            if (semver.minorVersion() >= target) {
                throw NormalVersion.newIllegalIncrementError(this, target, semver);
            }
            return Version.of((long)semver.majorVersion(), (long)target);
        }
    }
    ,
    PATCH{

        @Override
        public long getNumber(Version semver) {
            return semver.patchVersion();
        }

        @Override
        public Version incrementTo(long target, Version semver) {
            if (semver.patchVersion() >= target) {
                throw NormalVersion.newIllegalIncrementError(this, target, semver);
            }
            return Version.of((long)semver.majorVersion(), (long)semver.minorVersion(), (long)target);
        }
    };


    @NonNull
    private static IllegalArgumentException newIllegalIncrementError(NormalVersion normalVersion, long target, Version semver) {
        String errorMessage = String.format("%s version of %s is already higher than its increment target %d", new Object[]{normalVersion, semver, target});
        return new IllegalArgumentException(errorMessage);
    }

    @Nonnull
    public static NormalVersion getLastIncrementedNormalVersion(@Nonnull Version version) {
        long major = version.majorVersion();
        long minor = version.minorVersion();
        long patch = version.patchVersion();
        if (major == 0L && minor == 0L && patch == 0L) {
            throw new IllegalArgumentException("At least one normal number is expected to be non-zero: " + String.valueOf(version));
        }
        if (minor == 0L && patch == 0L) {
            return MAJOR;
        }
        if (patch == 0L) {
            return MINOR;
        }
        return PATCH;
    }

    public abstract long getNumber(Version var1);

    public abstract Version incrementTo(long var1, Version var3);
}

