/*
 * Decompiled with CFR 0.152.
 */
package q3769.maven.plugins.semver;

import com.github.zafarkhaja.semver.Version;
import lombok.NonNull;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class SemverMojo
extends AbstractMojo {
    private static final String FALSE = "false";
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    protected MojoExecution mojo;
    @Parameter(property="processModule", defaultValue="false")
    protected String processModule;
    @Parameter(property="project", defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="session", defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;

    @NonNull
    public static Version requireValidSemVer(String version) {
        try {
            return Version.parse((String)version);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Error parsing '" + version + "' as a SemVer", ex);
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String projectName = this.project.getName();
        String pomVersion = this.originalPomVersion();
        this.logInfo("Goal '%s' processing project '%s' with POM version '%s'...", this.mojo.getGoal(), projectName, pomVersion);
        if (this.project.hasParent()) {
            this.logInfo("current project %s is a module of %s", projectName, this.project.getParent().getName());
            if (FALSE.equalsIgnoreCase(this.processModule)) {
                this.logWarn("Version of module '%s' will not be processed. By default, only parent project is processed; if otherwise desired, use the `-DprocessModule` CLI flag", projectName);
                return;
            }
            if (pomVersion == null) {
                this.logWarn("Version of module '%s' is inherited to be the same as parent '%s', thus will not be processed independently", projectName, this.project.getParent().getName());
                return;
            }
        }
        this.doExecute();
    }

    protected String originalPomVersion() {
        return this.project.getOriginalModel().getVersion();
    }

    protected void logError(String message, Object ... args) {
        this.getLog().error((CharSequence)String.format(message, args));
    }

    protected void logError(Throwable t, String message, Object ... args) {
        this.getLog().error((CharSequence)String.format(message, args), t);
    }

    protected void logWarn(String message, Object ... args) {
        this.getLog().warn((CharSequence)String.format(message, args));
    }

    protected void logInfo(String message, Object ... args) {
        this.getLog().info((CharSequence)String.format(message, args));
    }

    protected void logDebug(String message, Object ... args) {
        this.getLog().debug((CharSequence)String.format(message, args));
    }
}

