/*
 * Decompiled with CFR 0.152.
 */
package q3769.maven.plugins.semver;

import com.github.zafarkhaja.semver.Version;
import lombok.NonNull;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import q3769.maven.plugins.semver.SemverMojo;

public abstract class Updater
extends SemverMojo {
    private static final String SNAPSHOT = "SNAPSHOT";
    @Parameter(property="snapshot", defaultValue="false")
    protected boolean addingSnapshotLabel;
    @Component
    protected BuildPluginManager pluginManager;

    protected abstract Version update(Version var1) throws MojoFailureException;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.updatePomFile(this.getUpdatedVersion().toString());
    }

    private Version getUpdatedVersion() throws MojoFailureException {
        Version original = Updater.requireValidSemVer(this.project.getVersion());
        Version updatedVersion = this.update(original);
        if (!this.addingSnapshotLabel) {
            return updatedVersion;
        }
        if (Updater.hasPreReleaseVersionOrBuildMetadata(updatedVersion)) {
            this.logError("SNAPSHOT labeling requested for POM version %s but not honored, because SNAPSHOT may collide with other labels in the updated version %s", original, updatedVersion);
            throw new MojoFailureException(String.format("SNAPSHOT may collide with other labels in %s", updatedVersion));
        }
        this.logInfo("labeling version %s as a SNAPSHOT...", updatedVersion);
        return Updater.addSnapshotLabel(updatedVersion);
    }

    private static boolean hasPreReleaseVersionOrBuildMetadata(@NonNull Version version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return version.preReleaseVersion().isPresent() || version.buildMetadata().isPresent();
    }

    private static Version addSnapshotLabel(@NonNull Version version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return version.toBuilder().setPreReleaseVersion(new String[]{SNAPSHOT}).build();
    }

    private void updatePomFile(@NonNull String newVersion) throws MojoExecutionException {
        if (newVersion == null) {
            throw new NullPointerException("newVersion is marked non-null but is null");
        }
        String originalVersion = this.project.getVersion();
        String executedGoal = this.mojo.getGoal();
        if (newVersion.equals(originalVersion)) {
            this.logInfo("Original POM version: %s remains unchanged after executing goal: %s", originalVersion, executedGoal);
            return;
        }
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"versions-maven-plugin"), (String)MojoExecutor.version((String)"2.17.1")), (String)MojoExecutor.goal((String)"set"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"generateBackupPoms"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"newVersion"), (String)newVersion)}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        this.logInfo("Updated original POM version: %s into: %s after executing goal: %s", originalVersion, newVersion, executedGoal);
    }
}

