/*
 * Decompiled with CFR 0.152.
 */
package q3769.maven.plugins.semver.mojos;

import com.github.zafarkhaja.semver.Version;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nonnull;
import lombok.NonNull;
import q3769.maven.plugins.semver.NormalVersion;

enum CalendarNormalVersionIncrementer {
    TO_YEAR("yyyy"),
    TO_MONTH("yyyyMM"),
    TO_DAY("yyyyMMdd"),
    TO_HOUR("yyyyMMddHH"),
    TO_MINUTE("yyyyMMddHHmm"),
    TO_SECOND("yyyyMMddHHmmss"),
    TO_MILLISECOND("yyyyMMddHHmmssSSS");

    private final DateTimeFormatter dateTimeFormatter;

    private CalendarNormalVersionIncrementer(String pattern) {
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
    }

    public static Version calendarIncrement(Version original, @Nonnull NormalVersion selectedNormalVersion) {
        long selectedNormalVersionNumber = selectedNormalVersion.getNumber(original);
        Instant now = Instant.now();
        for (CalendarNormalVersionIncrementer formatter : CalendarNormalVersionIncrementer.values()) {
            long updatedNormalVersionNumber = formatter.format(now);
            if (updatedNormalVersionNumber <= selectedNormalVersionNumber) continue;
            return selectedNormalVersion.incrementTo(updatedNormalVersionNumber, original);
        }
        throw new UnsupportedOperationException(String.format("%s version %s in POM semver %s is not supported for calendar style increment - it has to be older than current date in UTC zone", new Object[]{selectedNormalVersion, selectedNormalVersionNumber, original}));
    }

    long format(@NonNull Instant instant) {
        if (instant == null) {
            throw new NullPointerException("instant is marked non-null but is null");
        }
        return Long.parseLong(this.dateTimeFormatter.format(instant.atZone(ZoneOffset.UTC)));
    }
}

