/*
 * Decompiled with CFR 0.152.
 */
package q3769.maven.plugins.semver.mojos;

import com.github.zafarkhaja.semver.Version;
import lombok.NonNull;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import q3769.maven.plugins.semver.NormalVersion;
import q3769.maven.plugins.semver.Updater;

@Mojo(name="merge", defaultPhase=LifecyclePhase.NONE)
public class Merge
extends Updater {
    @Parameter(property="semver", defaultValue="NOT_SET")
    protected String otherSemVer;

    @Override
    protected Version update(Version original) throws MojoFailureException {
        Version incrementedVersion;
        Version other = Merge.requireValidSemVer(this.otherSemVer);
        this.logDebug("Merging current POM version %s with provided version %s", original, other);
        if (original.isHigherThan(other)) {
            this.logDebug("Current POM version %s is newer than provided version %s, current unchanged is the merge result: %s", original, other, original);
            return original;
        }
        this.logDebug("Provided version %s is newer than current POM version %s", other, original);
        NormalVersion pomIncrementedNormalVersion = NormalVersion.getLastIncrementedNormalVersion(original);
        this.logDebug("Last incremented normal version of current pom semver is %s", new Object[]{pomIncrementedNormalVersion});
        try {
            incrementedVersion = this.increment(other, pomIncrementedNormalVersion);
        }
        catch (Exception e) {
            this.logError(e, "Failed to merge the provided version %s with the POM version %s", other, original);
            throw new MojoFailureException((Throwable)e);
        }
        this.logDebug("Incrementing provided version %s on POM semver incremented normal version %s, provisional merge version: %s", new Object[]{other, pomIncrementedNormalVersion, incrementedVersion});
        Version.Builder versionBuilder = incrementedVersion.toBuilder();
        original.preReleaseVersion().ifPresent(xva$0 -> versionBuilder.setPreReleaseVersion(new String[]{xva$0}));
        original.buildMetadata().ifPresent(xva$0 -> versionBuilder.setBuildMetadata(new String[]{xva$0}));
        Version mergedVersion = versionBuilder.build();
        this.logDebug("Keeping all label(s) of POM semver %s, final merge version: %s", original, mergedVersion);
        return mergedVersion;
    }

    private Version increment(Version version, @NonNull NormalVersion targetNormalVersion) {
        if (targetNormalVersion == null) {
            throw new NullPointerException("targetNormalVersion is marked non-null but is null");
        }
        switch (targetNormalVersion) {
            case MAJOR: {
                return version.nextMajorVersion(new String[0]);
            }
            case MINOR: {
                return version.nextMinorVersion(new String[0]);
            }
            case PATCH: {
                return version.nextPatchVersion(new String[0]);
            }
        }
        throw new IllegalStateException(String.format("Unexpected targetNormalVersion: %s", new Object[]{targetNormalVersion}));
    }
}

