/*
 * Decompiled with CFR 0.152.
 */
package q3769.maven.plugins.semver.mojos;

import com.github.zafarkhaja.semver.Version;
import lombok.NonNull;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import q3769.maven.plugins.semver.NormalVersion;
import q3769.maven.plugins.semver.Updater;
import q3769.maven.plugins.semver.mojos.CalendarNormalVersionIncrementer;

@Mojo(name="merge-calendar", defaultPhase=LifecyclePhase.NONE)
public class MergeCalendar
extends Updater {
    @Parameter(property="semver", defaultValue="NOT_SET")
    protected String otherSemVer;

    @Override
    protected Version update(@NonNull Version original) throws MojoFailureException {
        Version provisionalMergedVersion;
        if (original == null) {
            throw new NullPointerException("original is marked non-null but is null");
        }
        this.logDebug("Merging current POM version %s with provided version %s", original, this.otherSemVer);
        Version other = MergeCalendar.requireValidSemVer(this.otherSemVer);
        if (original.isHigherThan(other)) {
            this.logDebug("Current POM version %s is newer than provided version %s, current unchanged is the merge result: %s", original, other, original);
            return original;
        }
        this.logDebug("Provided version %s is newer than current POM version %s", other, original);
        NormalVersion pomIncrementedNormalVersion = NormalVersion.getLastIncrementedNormalVersion(original);
        this.logDebug("Last incremented normal version of current pom semver is %s", new Object[]{pomIncrementedNormalVersion});
        try {
            provisionalMergedVersion = CalendarNormalVersionIncrementer.calendarIncrement(other, pomIncrementedNormalVersion);
        }
        catch (Exception e) {
            this.logError(e, "Failed to calendar-merge provided version %s with the POM version %s", other, original);
            throw new MojoFailureException((Throwable)e);
        }
        this.logDebug("Incrementing provided version %s on POM semver incremented normal version %s, provisional merge version: %s", new Object[]{other, pomIncrementedNormalVersion, provisionalMergedVersion});
        Version.Builder versionBuilder = provisionalMergedVersion.toBuilder();
        original.preReleaseVersion().ifPresent(xva$0 -> versionBuilder.setPreReleaseVersion(new String[]{xva$0}));
        original.buildMetadata().ifPresent(xva$0 -> versionBuilder.setBuildMetadata(new String[]{xva$0}));
        Version finalMergedVersion = versionBuilder.build();
        this.logDebug("Keeping all label(s) of POM semver %s, final merge version: %s", original, finalMergedVersion);
        return finalMergedVersion;
    }
}

