/*
 * Decompiled with CFR 0.152.
 */
package q3769.maven.plugins.semver.mojos;

import com.github.zafarkhaja.semver.Version;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import q3769.maven.plugins.semver.Updater;

@Mojo(name="pick-newer", defaultPhase=LifecyclePhase.NONE)
public class PickNewer
extends Updater {
    @Parameter(property="semver", defaultValue="NOT_SET", required=true)
    protected String otherSemVer;

    @Override
    protected Version update(Version original) {
        this.logDebug("Taking the newer between current version %s and given version %s", original, this.otherSemVer);
        Version other = PickNewer.requireValidSemVer(this.otherSemVer);
        if (original.isHigherThanOrEquivalentTo(other)) {
            this.logDebug("Current POM version %s is newer and being picked", original);
            return original;
        }
        this.logDebug("CLI provided version %s is newer and being picked", this.otherSemVer);
        return other;
    }
}

