/*
 * Decompiled with CFR 0.152.
 */
package q3769.maven.plugins.semver.mojos;

import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import q3769.maven.plugins.semver.SemverMojo;

@Mojo(name="verify-current", defaultPhase=LifecyclePhase.NONE)
public class VerifyCurrent
extends SemverMojo {
    @Parameter(property="force-stdout", defaultValue="false")
    protected boolean forceStdOut;

    @Override
    protected void doExecute() throws MojoFailureException {
        String version = this.originalPomVersion();
        try {
            VerifyCurrent.requireValidSemVer(version);
        }
        catch (Exception e) {
            this.logError(e, "POM version '%s' is not a valid SemVer", version);
            throw new MojoFailureException((Throwable)e);
        }
        this.logInfo("POM version '%s' is a valid SemVer", version);
        if (this.forceStdOut) {
            System.out.println(version);
        }
    }
}

