/*
 * Decompiled with CFR 0.152.
 */
package io.github.qbast.azurewagon.abs;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.AzureCliCredentialBuilder;
import com.azure.identity.ChainedTokenCredentialBuilder;
import com.azure.identity.EnvironmentCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.apache.maven.wagon.authentication.AuthenticationInfo;

public class AuthenticationHandler {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationHandler.class.getName());
    private static final String ENDPOINT_TEMPLATE = "https://%s.blob.core.windows.net/";
    private static final ConcurrentMap<String, BlobServiceClient> builders = new ConcurrentHashMap<String, BlobServiceClient>();

    public static BlobServiceClient get(String accountName, AuthenticationInfo authentication) {
        return builders.computeIfAbsent(accountName, ac -> AuthenticationHandler.createAuthenticatedBuilder(ac, authentication).buildClient());
    }

    private static BlobServiceClientBuilder createAuthenticatedBuilder(String accountName, AuthenticationInfo authentication) {
        BlobServiceClientBuilder builder = new BlobServiceClientBuilder().endpoint(String.format(ENDPOINT_TEMPLATE, accountName));
        if (authentication != null) {
            builder.credential(new StorageSharedKeyCredential(authentication.getUserName(), authentication.getPassword()));
        } else {
            builder.credential(AuthenticationHandler.createAzureAdCredential());
        }
        LOGGER.finer(String.format("Created authenticated client for account %s", accountName));
        return builder;
    }

    private static TokenCredential createAzureAdCredential() {
        return new ChainedTokenCredentialBuilder().addAll(Arrays.asList(new EnvironmentCredentialBuilder().build(), new ManagedIdentityCredentialBuilder().build(), new AzureCliCredentialBuilder().build())).build();
    }
}

