/*
 * Decompiled with CFR 0.152.
 */
package io.github.qbast.azurewagon.abs;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.specialized.BlobInputStream;
import io.github.qbast.azurewagon.abs.AuthenticationHandler;
import io.github.qbast.azurewagon.abs.ContentTypeResolver;
import io.github.qbast.azurewagon.transfer.TransferProgress;
import io.github.qbast.azurewagon.transfer.TransferProgressFileInputStream;
import io.github.qbast.azurewagon.transfer.TransferProgressFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;

public class AzureStorageRepository {
    private final String container;
    private final String accountName;
    private BlobContainerClient blobContainer;
    private static final Logger LOGGER = Logger.getLogger(AzureStorageRepository.class.getName());

    public AzureStorageRepository(String account, String directory) {
        this.container = directory;
        this.accountName = account;
    }

    public void connect(AuthenticationInfo authenticationInfo) throws AuthenticationException {
        try {
            BlobServiceClient cloudStorageAccount = AuthenticationHandler.get(this.accountName, authenticationInfo);
            this.blobContainer = cloudStorageAccount.getBlobContainerClient(this.container);
            this.blobContainer.exists();
        }
        catch (BlobStorageException e) {
            throw new AuthenticationException("Provide valid credentials", (Throwable)e);
        }
    }

    public void copy(String resourceName, File destination, TransferProgress transferProgress) throws ResourceDoesNotExistException {
        LOGGER.log(Level.FINER, String.format("Downloading key %s from container %s into %s", resourceName, this.container, destination.getAbsolutePath()));
        try {
            BlobClient cloudBlob = this.blobContainer.getBlobClient(resourceName);
            if (!cloudBlob.exists().booleanValue()) {
                LOGGER.log(Level.FINER, "Blob {} does not exist", resourceName);
                throw new ResourceDoesNotExistException(resourceName);
            }
            try (TransferProgressFileOutputStream outputStream = new TransferProgressFileOutputStream(destination, transferProgress);
                 BlobInputStream inputStream = cloudBlob.openInputStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        }
        catch (BlobStorageException | IOException e) {
            throw new ResourceDoesNotExistException("Could not download file from repo", e);
        }
    }

    public boolean newResourceAvailable(String resourceName, long timeStamp) throws ResourceDoesNotExistException {
        LOGGER.log(Level.FINER, String.format("Checking if new key %s exists", resourceName));
        try {
            BlobClient cloudBlob = this.blobContainer.getBlobClient(resourceName);
            if (!cloudBlob.exists().booleanValue()) {
                return false;
            }
            long updated = cloudBlob.getProperties().getLastModified().toEpochSecond();
            return updated > timeStamp;
        }
        catch (BlobStorageException e) {
            LOGGER.log(Level.SEVERE, "Could not fetch cloud blob", e);
            throw new ResourceDoesNotExistException(resourceName);
        }
    }

    public void put(File file, String destination, TransferProgress transferProgress) throws TransferFailedException {
        LOGGER.log(Level.FINER, String.format("Uploading key %s ", destination));
        try {
            BlobClient blob = this.blobContainer.getBlobClient(destination);
            BlobHttpHeaders headers = new BlobHttpHeaders();
            headers.setContentType(ContentTypeResolver.getContentType(file));
            try (TransferProgressFileInputStream inputStream = new TransferProgressFileInputStream(file, transferProgress);){
                blob.uploadWithResponse((InputStream)inputStream, file.length(), null, headers, null, null, null, null, Context.NONE);
            }
        }
        catch (BlobStorageException | IOException e) {
            LOGGER.log(Level.SEVERE, "Could not fetch cloud blob", e);
            throw new TransferFailedException(destination);
        }
    }

    public boolean exists(String resourceName) throws TransferFailedException {
        try {
            BlobClient blob = this.blobContainer.getBlobClient(resourceName);
            return blob.exists();
        }
        catch (BlobStorageException e) {
            LOGGER.log(Level.SEVERE, "Could not fetch cloud blob", e);
            throw new TransferFailedException(resourceName);
        }
    }

    public List<String> list(String path) {
        LOGGER.info(String.format("Listing files for %s", path));
        ArrayList<String> blobs = new ArrayList<String>();
        PagedIterable blobItems = this.blobContainer.listBlobs();
        for (BlobItem blobItem : blobItems) {
            blobs.add(blobItem.getName());
        }
        return blobs;
    }

    public void disconnect() {
        this.blobContainer = null;
    }
}

