/*
 * Decompiled with CFR 0.152.
 */
package io.github.qbast.azurewagon.abs;

import io.github.qbast.azurewagon.abs.AzureStorageRepository;
import io.github.qbast.azurewagon.transfer.TransferProgressImpl;
import io.github.qbast.azurewagon.wagon.AbstractStorageWagon;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;

public class AzureStorageWagon
extends AbstractStorageWagon {
    private AzureStorageRepository azureStorageRepository;
    private static final Logger LOGGER = Logger.getLogger(AzureStorageWagon.class.getName());

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.transferListenerContainer.fireTransferInitiated(resource, 5);
        this.transferListenerContainer.fireTransferStarted(resource, 5, destination);
        TransferProgressImpl transferProgress = new TransferProgressImpl(resource, 5, this.transferListenerContainer);
        try {
            this.azureStorageRepository.copy(resourceName, destination, transferProgress);
            this.transferListenerContainer.fireTransferCompleted(resource, 5);
        }
        catch (Exception e) {
            this.transferListenerContainer.fireTransferError(resource, 5, e);
            throw e;
        }
    }

    public boolean getIfNewer(String resourceName, File file, long l) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        try {
            if (this.azureStorageRepository.newResourceAvailable(resourceName, l)) {
                this.get(resourceName, file);
                return true;
            }
            return false;
        }
        catch (ResourceDoesNotExistException | TransferFailedException | AuthorizationException e) {
            this.transferListenerContainer.fireTransferError(resource, 5, (Exception)e);
            throw e;
        }
    }

    public void put(File file, String resourceName) throws TransferFailedException {
        resourceName = Paths.get(resourceName, new String[0]).normalize().toString();
        Resource resource = new Resource(resourceName);
        LOGGER.log(Level.FINER, String.format("Uploading file %s to %s", file.getAbsolutePath(), resourceName));
        this.transferListenerContainer.fireTransferInitiated(resource, 6);
        this.transferListenerContainer.fireTransferStarted(resource, 6, file);
        TransferProgressImpl transferProgress = new TransferProgressImpl(resource, 6, this.transferListenerContainer);
        try {
            this.azureStorageRepository.put(file, resourceName, transferProgress);
            this.transferListenerContainer.fireTransferCompleted(resource, 6);
        }
        catch (TransferFailedException e) {
            this.transferListenerContainer.fireTransferError(resource, 6, (Exception)((Object)e));
            throw e;
        }
    }

    public void putDirectory(File source, String destination) throws TransferFailedException {
        File[] files = source.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.putDirectory(f, destination + "/" + f.getName());
                    continue;
                }
                this.put(f, destination + "/" + f.getName());
            }
        }
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException {
        try {
            return this.azureStorageRepository.exists(resourceName);
        }
        catch (TransferFailedException e) {
            this.transferListenerContainer.fireTransferError(new Resource(resourceName), 5, (Exception)((Object)e));
            throw e;
        }
    }

    public List<String> getFileList(String resourceName) throws TransferFailedException {
        try {
            return this.azureStorageRepository.list(resourceName);
        }
        catch (Exception e) {
            this.transferListenerContainer.fireTransferError(new Resource(resourceName), 5, e);
            throw new TransferFailedException("Could not fetch resource");
        }
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws AuthenticationException {
        this.repository = repository;
        this.sessionListenerContainer.fireSessionOpening();
        try {
            String account = this.accountResolver.resolve(repository);
            String container = this.containerResolver.resolve(repository);
            LOGGER.log(Level.FINER, String.format("Opening connection for account %s and container %s", account, container));
            this.azureStorageRepository = new AzureStorageRepository(account, container);
            this.azureStorageRepository.connect(authenticationInfo);
            this.sessionListenerContainer.fireSessionLoggedIn();
            this.sessionListenerContainer.fireSessionOpened();
        }
        catch (Exception e) {
            this.sessionListenerContainer.fireSessionConnectionRefused();
            throw e;
        }
    }

    public void disconnect() {
        this.sessionListenerContainer.fireSessionDisconnecting();
        this.azureStorageRepository.disconnect();
        this.sessionListenerContainer.fireSessionLoggedOff();
        this.sessionListenerContainer.fireSessionDisconnected();
    }
}

