/*
 * Decompiled with CFR 0.152.
 */
package io.github.qbast.azurewagon.transfer;

import io.github.qbast.azurewagon.transfer.TransferProgress;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public final class TransferProgressFileInputStream
extends FileInputStream {
    private final TransferProgress transferProgress;

    public TransferProgressFileInputStream(File file, TransferProgress transferProgress) throws IOException {
        super(file);
        this.transferProgress = transferProgress;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b != -1) {
            this.transferProgress.progress(new byte[]{(byte)b}, 1);
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int count = super.read(b);
        if (count < 1) {
            return count;
        }
        this.transferProgress.progress(b, count);
        return count;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = super.read(b, off, len);
        if (count < 1) {
            return count;
        }
        if (off == 0) {
            this.transferProgress.progress(b, count);
        } else {
            byte[] bytes = new byte[count];
            System.arraycopy(b, off, bytes, 0, count);
            this.transferProgress.progress(bytes, count);
        }
        return count;
    }
}

