/*
 * Decompiled with CFR 0.152.
 */
package io.github.qbast.azurewagon.wagon;

import io.github.qbast.azurewagon.listener.SessionListenerContainer;
import io.github.qbast.azurewagon.listener.SessionListenerContainerImpl;
import io.github.qbast.azurewagon.listener.TransferListenerContainer;
import io.github.qbast.azurewagon.listener.TransferListenerContainerImpl;
import io.github.qbast.azurewagon.resolver.BaseDirectoryResolver;
import io.github.qbast.azurewagon.resolver.BucketResolver;
import java.util.logging.Logger;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;

public abstract class AbstractStorageWagon
implements Wagon {
    private static final boolean SUPPORTS_DIRECTORY_COPY = true;
    private int connectionTimeOut = 0;
    private int readConnectionTimeOut = 0;
    protected Repository repository = null;
    protected final BucketResolver accountResolver = new BucketResolver();
    protected final BaseDirectoryResolver containerResolver = new BaseDirectoryResolver();
    protected final SessionListenerContainer sessionListenerContainer = new SessionListenerContainerImpl(this);
    protected final TransferListenerContainer transferListenerContainer = new TransferListenerContainerImpl(this);
    private boolean interactive;
    private static final Logger LOGGER = Logger.getLogger(AbstractStorageWagon.class.getName());

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void openConnection() throws ConnectionException, AuthenticationException {
        throw new UnsupportedOperationException();
    }

    public void connect(Repository repository) throws ConnectionException, AuthenticationException {
        this.connect(repository, null, null);
    }

    public void connect(Repository repository, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository, null, proxyInfo);
    }

    public void connect(Repository repository, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.connect(repository, null, proxyInfoProvider);
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository, authenticationInfo, null);
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository, authenticationInfo, p -> {
            if (p == null || proxyInfo == null || p.equalsIgnoreCase(proxyInfo.getType())) {
                return proxyInfo;
            }
            return null;
        });
    }

    public void setTimeout(int i) {
        this.connectionTimeOut = i;
    }

    public int getTimeout() {
        return this.connectionTimeOut;
    }

    public void setReadTimeout(int i) {
        this.readConnectionTimeOut = i;
    }

    public int getReadTimeout() {
        return this.readConnectionTimeOut;
    }

    public void addSessionListener(SessionListener sessionListener) {
        this.sessionListenerContainer.addSessionListener(sessionListener);
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.sessionListenerContainer.removeSessionListener(sessionListener);
    }

    public boolean hasSessionListener(SessionListener sessionListener) {
        return this.sessionListenerContainer.hasSessionListener(sessionListener);
    }

    public void addTransferListener(TransferListener transferListener) {
        this.transferListenerContainer.addTransferListener(transferListener);
    }

    public void removeTransferListener(TransferListener transferListener) {
        this.transferListenerContainer.removeTransferListener(transferListener);
    }

    public boolean hasTransferListener(TransferListener transferListener) {
        return this.transferListenerContainer.hasTransferListener(transferListener);
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean b) {
        this.interactive = b;
    }
}

