/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.cache.disk;

import androidx.compose.runtime.internal.StabilityInferred;
import com.seiko.imageloader.cache.disk.DiskCache;
import com.seiko.imageloader.cache.disk.DiskCacheBuilder_androidKt;
import com.seiko.imageloader.cache.disk.RealDiskCache;
import com.seiko.imageloader.util.Platform_jvmKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineDispatcher;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0003\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/seiko/imageloader/cache/disk/DiskCacheBuilder;", "", "()V", "cleanupDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "directory", "Lokio/Path;", "fileSystem", "Lokio/FileSystem;", "maxSizeBytes", "", "maxSizePercent", "", "maximumMaxSizeBytes", "minimumMaxSizeBytes", "build", "Lcom/seiko/imageloader/cache/disk/DiskCache;", "", "dispatcher", "size", "percent", "image-loader_debug"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDiskCacheBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskCacheBuilder.kt\ncom/seiko/imageloader/cache/disk/DiskCacheBuilder\n+ 2 DiskCacheBuilder.android.kt\ncom/seiko/imageloader/cache/disk/DiskCacheBuilder_androidKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n8#2:86\n1#3:87\n*S KotlinDebug\n*F\n+ 1 DiskCacheBuilder.kt\ncom/seiko/imageloader/cache/disk/DiskCacheBuilder\n*L\n11#1:86\n*E\n"})
public final class DiskCacheBuilder {
    @Nullable
    private Path directory;
    @NotNull
    private FileSystem fileSystem;
    private double maxSizePercent;
    private long minimumMaxSizeBytes;
    private long maximumMaxSizeBytes;
    private long maxSizeBytes;
    @NotNull
    private CoroutineDispatcher cleanupDispatcher;
    public static final int $stable = 8;

    public DiskCacheBuilder() {
        boolean $i$f$getSystemFileSystem = false;
        this.fileSystem = FileSystem.SYSTEM;
        this.maxSizePercent = 0.02;
        this.minimumMaxSizeBytes = 0xA00000L;
        this.maximumMaxSizeBytes = 0xFA00000L;
        this.cleanupDispatcher = Platform_jvmKt.getIoDispatcher();
    }

    public final void directory(@NotNull Path directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.directory = directory;
    }

    public final void fileSystem(@NotNull FileSystem fileSystem2) {
        Intrinsics.checkNotNullParameter((Object)fileSystem2, (String)"fileSystem");
        this.fileSystem = fileSystem2;
    }

    public final void maxSizePercent(double percent) {
        if (!(0.0 <= percent ? percent <= 1.0 : false)) {
            boolean bl = false;
            String string = "size must be in the range [0.0, 1.0].";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxSizeBytes = 0L;
        this.maxSizePercent = percent;
    }

    public final void minimumMaxSizeBytes(long size2) {
        if (!(size2 > 0L)) {
            boolean bl = false;
            String string = "size must be > 0.";
            throw new IllegalArgumentException(string.toString());
        }
        this.minimumMaxSizeBytes = size2;
    }

    public final void maximumMaxSizeBytes(long size2) {
        if (!(size2 > 0L)) {
            boolean bl = false;
            String string = "size must be > 0.";
            throw new IllegalArgumentException(string.toString());
        }
        this.maximumMaxSizeBytes = size2;
    }

    public final void maxSizeBytes(long size2) {
        if (!(size2 > 0L)) {
            boolean bl = false;
            String string = "size must be > 0.";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxSizePercent = 0.0;
        this.maxSizeBytes = size2;
    }

    public final void cleanupDispatcher(@NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.cleanupDispatcher = dispatcher;
    }

    @NotNull
    public final DiskCache build() {
        long l;
        Path path = this.directory;
        if (path == null) {
            boolean bl = false;
            String string = "directory == null";
            throw new IllegalStateException(string.toString());
        }
        Path directory = path;
        if (this.maxSizePercent > 0.0) {
            long l2;
            try {
                double size2 = this.maxSizePercent * (double)DiskCacheBuilder_androidKt.directorySize(directory);
                l2 = RangesKt.coerceIn((long)((long)size2), (long)this.minimumMaxSizeBytes, (long)this.maximumMaxSizeBytes);
            }
            catch (Exception exception) {
                l2 = this.minimumMaxSizeBytes;
            }
            l = l2;
        } else {
            l = this.maxSizeBytes;
        }
        long maxSize = l;
        return new RealDiskCache(maxSize, directory, this.fileSystem, this.cleanupDispatcher);
    }
}

