/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.cache.disk;

import com.seiko.imageloader.cache.disk.DiskCache;
import com.seiko.imageloader.cache.disk.DiskLruCache;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import okio.ByteString;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000  2\u00020\u0001:\u0003 !\"B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001f\u001a\u00020\u001a*\u00020\u001aH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/seiko/imageloader/cache/disk/RealDiskCache;", "Lcom/seiko/imageloader/cache/disk/DiskCache;", "maxSize", "", "directory", "Lokio/Path;", "fileSystem", "Lokio/FileSystem;", "cleanupDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(JLokio/Path;Lokio/FileSystem;Lkotlinx/coroutines/CoroutineDispatcher;)V", "cache", "Lcom/seiko/imageloader/cache/disk/DiskLruCache;", "getDirectory", "()Lokio/Path;", "getFileSystem", "()Lokio/FileSystem;", "getMaxSize", "()J", "size", "getSize", "clear", "", "edit", "Lcom/seiko/imageloader/cache/disk/DiskCache$Editor;", "key", "", "get", "Lcom/seiko/imageloader/cache/disk/DiskCache$Snapshot;", "remove", "", "hash", "Companion", "RealEditor", "RealSnapshot", "image-loader_debug"})
@SourceDebugExtension(value={"SMAP\nRealDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealDiskCache.kt\ncom/seiko/imageloader/cache/disk/RealDiskCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class RealDiskCache
implements DiskCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long maxSize;
    @NotNull
    private final Path directory;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final DiskLruCache cache;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_DATA = 1;

    public RealDiskCache(long maxSize, @NotNull Path directory, @NotNull FileSystem fileSystem2, @NotNull CoroutineDispatcher cleanupDispatcher) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileSystem2, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)cleanupDispatcher, (String)"cleanupDispatcher");
        this.maxSize = maxSize;
        this.directory = directory;
        this.fileSystem = fileSystem2;
        this.cache = new DiskLruCache(this.getFileSystem(), this.getDirectory(), cleanupDispatcher, this.getMaxSize(), 1, 2);
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    @NotNull
    public Path getDirectory() {
        return this.directory;
    }

    @Override
    @NotNull
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public long getSize() {
        return this.cache.size();
    }

    @Override
    @Nullable
    public DiskCache.Snapshot get(@NotNull String key) {
        RealSnapshot realSnapshot;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        DiskLruCache.Snapshot snapshot2 = this.cache.get(this.hash(key));
        if (snapshot2 != null) {
            DiskLruCache.Snapshot p0 = snapshot2;
            boolean bl = false;
            realSnapshot = new RealSnapshot(p0);
        } else {
            realSnapshot = null;
        }
        return realSnapshot;
    }

    @Override
    @Nullable
    public DiskCache.Editor edit(@NotNull String key) {
        RealEditor realEditor;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        DiskLruCache.Editor editor = this.cache.edit(this.hash(key));
        if (editor != null) {
            DiskLruCache.Editor p0 = editor;
            boolean bl = false;
            realEditor = new RealEditor(p0);
        } else {
            realEditor = null;
        }
        return realEditor;
    }

    @Override
    public boolean remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.cache.remove(this.hash(key));
    }

    @Override
    public void clear() {
        this.cache.evictAll();
    }

    private final String hash(String $this$hash) {
        return ByteString.Companion.encodeUtf8($this$hash).sha256().hex();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/seiko/imageloader/cache/disk/RealDiskCache$Companion;", "", "()V", "ENTRY_DATA", "", "ENTRY_METADATA", "image-loader_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/seiko/imageloader/cache/disk/RealDiskCache$RealEditor;", "Lcom/seiko/imageloader/cache/disk/DiskCache$Editor;", "editor", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Editor;", "Lcom/seiko/imageloader/cache/disk/DiskLruCache;", "(Lcom/seiko/imageloader/cache/disk/DiskLruCache$Editor;)V", "data", "Lokio/Path;", "getData", "()Lokio/Path;", "metadata", "getMetadata", "abort", "", "commit", "commitAndGet", "Lcom/seiko/imageloader/cache/disk/RealDiskCache$RealSnapshot;", "image-loader_debug"})
    @SourceDebugExtension(value={"SMAP\nRealDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealDiskCache.kt\ncom/seiko/imageloader/cache/disk/RealDiskCache$RealEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
    private static final class RealEditor
    implements DiskCache.Editor {
        @NotNull
        private final DiskLruCache.Editor editor;

        public RealEditor(@NotNull DiskLruCache.Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
        }

        @Override
        @NotNull
        public Path getMetadata() {
            return this.editor.file(0);
        }

        @Override
        @NotNull
        public Path getData() {
            return this.editor.file(1);
        }

        @Override
        public void commit() {
            this.editor.commit();
        }

        @Override
        @Nullable
        public RealSnapshot commitAndGet() {
            RealSnapshot realSnapshot;
            DiskLruCache.Snapshot snapshot2 = this.editor.commitAndGet();
            if (snapshot2 != null) {
                DiskLruCache.Snapshot p0 = snapshot2;
                boolean bl = false;
                realSnapshot = new RealSnapshot(p0);
            } else {
                realSnapshot = null;
            }
            return realSnapshot;
        }

        @Override
        public void abort() {
            this.editor.abort();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/seiko/imageloader/cache/disk/RealDiskCache$RealSnapshot;", "Lcom/seiko/imageloader/cache/disk/DiskCache$Snapshot;", "snapshot", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Snapshot;", "Lcom/seiko/imageloader/cache/disk/DiskLruCache;", "(Lcom/seiko/imageloader/cache/disk/DiskLruCache$Snapshot;)V", "data", "Lokio/Path;", "getData", "()Lokio/Path;", "metadata", "getMetadata", "close", "", "closeAndEdit", "Lcom/seiko/imageloader/cache/disk/RealDiskCache$RealEditor;", "image-loader_debug"})
    @SourceDebugExtension(value={"SMAP\nRealDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealDiskCache.kt\ncom/seiko/imageloader/cache/disk/RealDiskCache$RealSnapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
    private static final class RealSnapshot
    implements DiskCache.Snapshot {
        @NotNull
        private final DiskLruCache.Snapshot snapshot;

        public RealSnapshot(@NotNull DiskLruCache.Snapshot snapshot2) {
            Intrinsics.checkNotNullParameter((Object)snapshot2, (String)"snapshot");
            this.snapshot = snapshot2;
        }

        @Override
        @NotNull
        public Path getMetadata() {
            return this.snapshot.file(0);
        }

        @Override
        @NotNull
        public Path getData() {
            return this.snapshot.file(1);
        }

        @Override
        public void close() {
            this.snapshot.close();
        }

        @Override
        @Nullable
        public RealEditor closeAndEdit() {
            RealEditor realEditor;
            DiskLruCache.Editor editor = this.snapshot.closeAndEdit();
            if (editor != null) {
                DiskLruCache.Editor p0 = editor;
                boolean bl = false;
                realEditor = new RealEditor(p0);
            } else {
                realEditor = null;
            }
            return realEditor;
        }
    }
}

