/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.cache.memory;

import android.app.ActivityManager;
import android.content.Context;
import androidx.core.content.ContextCompat;
import com.seiko.imageloader.cache.memory.MemoryCacheBuilder;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a\f\u0010\f\u001a\u00020\u0003*\u00020\u0007H\u0002\u001a\u001c\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"DEFAULT_MEMORY_CLASS_MEGABYTES", "", "LOW_MEMORY_MULTIPLIER", "", "STANDARD_MEMORY_MULTIPLIER", "activityManager", "Landroid/app/ActivityManager;", "Landroid/content/Context;", "getActivityManager", "(Landroid/content/Context;)Landroid/app/ActivityManager;", "calculateMemoryCacheSize", "percent", "defaultMemoryCacheSizePercent", "maxSizePercent", "", "Lcom/seiko/imageloader/cache/memory/MemoryCacheBuilder;", "context", "image-loader_debug"})
@SourceDebugExtension(value={"SMAP\nMemoryCacheBuilder.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCacheBuilder.android.kt\ncom/seiko/imageloader/cache/memory/MemoryCacheBuilder_androidKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
public final class MemoryCacheBuilder_androidKt {
    private static final double STANDARD_MEMORY_MULTIPLIER = 0.2;
    private static final double LOW_MEMORY_MULTIPLIER = 0.15;
    private static final int DEFAULT_MEMORY_CLASS_MEGABYTES = 256;

    public static final void maxSizePercent(@NotNull MemoryCacheBuilder $this$maxSizePercent, @NotNull Context context, double percent) {
        Intrinsics.checkNotNullParameter((Object)$this$maxSizePercent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(0.0 <= percent ? percent <= 1.0 : false)) {
            boolean bl = false;
            String string = "size must be in the range [0.0, 1.0].";
            throw new IllegalArgumentException(string.toString());
        }
        int maxSizeBytes = MemoryCacheBuilder_androidKt.calculateMemoryCacheSize(context, percent);
        $this$maxSizePercent.maxSizeBytes(maxSizeBytes);
    }

    public static /* synthetic */ void maxSizePercent$default(MemoryCacheBuilder memoryCacheBuilder, Context context, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = MemoryCacheBuilder_androidKt.defaultMemoryCacheSizePercent(context);
        }
        MemoryCacheBuilder_androidKt.maxSizePercent(memoryCacheBuilder, context, d);
    }

    private static final double defaultMemoryCacheSizePercent(Context $this$defaultMemoryCacheSizePercent) {
        Object object;
        Object object2 = $this$defaultMemoryCacheSizePercent;
        try {
            Context $this$defaultMemoryCacheSizePercent_u24lambda_u241 = object2;
            boolean bl = false;
            ActivityManager activityManager = MemoryCacheBuilder_androidKt.getActivityManager($this$defaultMemoryCacheSizePercent_u24lambda_u241);
            object = Result.constructor-impl((Object)((activityManager != null ? activityManager.isLowRamDevice() : false) ? 0.15 : 0.2));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = 0.2;
        return ((Number)(Result.isFailure-impl((Object)object2) ? object : object2)).doubleValue();
    }

    private static final int calculateMemoryCacheSize(Context $this$calculateMemoryCacheSize, double percent) {
        Object object;
        Object object2 = $this$calculateMemoryCacheSize;
        try {
            Integer n;
            Context $this$calculateMemoryCacheSize_u24lambda_u242 = object2;
            boolean bl = false;
            ActivityManager activityManager = MemoryCacheBuilder_androidKt.getActivityManager($this$calculateMemoryCacheSize_u24lambda_u242);
            if (activityManager == null) {
                n = null;
            } else {
                ActivityManager activityManager2 = activityManager;
                boolean isLargeHeap = ($this$calculateMemoryCacheSize_u24lambda_u242.getApplicationInfo().flags & 0x100000) != 0;
                n = isLargeHeap ? activityManager2.getLargeMemoryClass() : activityManager2.getMemoryClass();
            }
            object = Result.constructor-impl(n);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Integer n = (Integer)(Result.isFailure-impl((Object)object2) ? null : object2);
        int memoryClassMegabytes = n != null ? n : 256;
        return (int)(percent * (double)memoryClassMegabytes * (double)1024 * (double)1024);
    }

    private static final ActivityManager getActivityManager(Context $this$activityManager) {
        return (ActivityManager)ContextCompat.getSystemService((Context)$this$activityManager, ActivityManager.class);
    }
}

