/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.cache.memory;

import android.graphics.Bitmap;
import com.seiko.imageloader.cache.memory.MemoryCache;
import com.seiko.imageloader.cache.memory.StrongMemoryCache;
import com.seiko.imageloader.cache.memory.WeakMemoryCache;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u001d\u0010\u0015\u001a\n\u0018\u00010\u0016j\u0004\u0018\u0001`\u00172\n\u0010\u0018\u001a\u00060\tj\u0002`\nH\u0096\u0002J\u0014\u0010\u0019\u001a\u00020\u001a2\n\u0010\u0018\u001a\u00060\tj\u0002`\nH\u0016J!\u0010\u001b\u001a\u00020\u00142\n\u0010\u0018\u001a\u00060\tj\u0002`\n2\n\u0010\u001c\u001a\u00060\u0016j\u0002`\u0017H\u0096\u0002R\u001e\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/seiko/imageloader/cache/memory/RealMemoryCache;", "Lcom/seiko/imageloader/cache/memory/MemoryCache;", "strongMemoryCache", "Lcom/seiko/imageloader/cache/memory/StrongMemoryCache;", "weakMemoryCache", "Lcom/seiko/imageloader/cache/memory/WeakMemoryCache;", "(Lcom/seiko/imageloader/cache/memory/StrongMemoryCache;Lcom/seiko/imageloader/cache/memory/WeakMemoryCache;)V", "keys", "", "", "Lcom/seiko/imageloader/cache/memory/MemoryKey;", "getKeys", "()Ljava/util/Set;", "maxSize", "", "getMaxSize", "()I", "size", "getSize", "clear", "", "get", "Landroid/graphics/Bitmap;", "Lcom/seiko/imageloader/cache/memory/MemoryValue;", "key", "remove", "", "set", "value", "image-loader_debug"})
public final class RealMemoryCache
implements MemoryCache {
    @NotNull
    private final StrongMemoryCache strongMemoryCache;
    @NotNull
    private final WeakMemoryCache weakMemoryCache;

    public RealMemoryCache(@NotNull StrongMemoryCache strongMemoryCache, @NotNull WeakMemoryCache weakMemoryCache) {
        Intrinsics.checkNotNullParameter((Object)strongMemoryCache, (String)"strongMemoryCache");
        Intrinsics.checkNotNullParameter((Object)weakMemoryCache, (String)"weakMemoryCache");
        this.strongMemoryCache = strongMemoryCache;
        this.weakMemoryCache = weakMemoryCache;
    }

    @Override
    public int getSize() {
        return this.strongMemoryCache.getSize();
    }

    @Override
    public int getMaxSize() {
        return this.strongMemoryCache.getMaxSize();
    }

    @Override
    @NotNull
    public Set<String> getKeys() {
        return SetsKt.plus(this.strongMemoryCache.getKeys(), (Iterable)this.weakMemoryCache.getKeys());
    }

    @Override
    @Nullable
    public Bitmap get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Bitmap bitmap = this.strongMemoryCache.get(key);
        if (bitmap == null) {
            bitmap = this.weakMemoryCache.get(key);
        }
        return bitmap;
    }

    @Override
    public void set(@NotNull String key, @NotNull Bitmap value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.strongMemoryCache.set(key, value, MapsKt.emptyMap());
    }

    @Override
    public boolean remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean removedStrong = this.strongMemoryCache.remove(key);
        boolean removedWeak = this.weakMemoryCache.remove(key);
        return removedStrong || removedWeak;
    }

    @Override
    public void clear() {
        this.strongMemoryCache.clearMemory();
        this.weakMemoryCache.clearMemory();
    }
}

