/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.cache.memory;

import android.graphics.Bitmap;
import com.seiko.imageloader.Bitmap_androidKt;
import com.seiko.imageloader.cache.memory.RealStrongMemoryCache;
import com.seiko.imageloader.cache.memory.StrongMemoryCache;
import com.seiko.imageloader.cache.memory.WeakMemoryCache;
import com.seiko.imageloader.util.LruCache;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002*\u0001\b\b\u0000\u0018\u00002\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u00182\n\u0010\u0019\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u001a\u001a\u00020\u001b2\n\u0010\u0019\u001a\u00060\fj\u0002`\rH\u0016J4\u0010\u001c\u001a\u00020\u00152\n\u0010\u0019\u001a\u00060\fj\u0002`\r2\n\u0010\u001d\u001a\u00060\u0017j\u0002`\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020!0 H\u0016R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u001e\u0010\n\u001a\f\u0012\b\u0012\u00060\fj\u0002`\r0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/seiko/imageloader/cache/memory/RealStrongMemoryCache;", "Lcom/seiko/imageloader/cache/memory/StrongMemoryCache;", "maxSize", "", "weakMemoryCache", "Lcom/seiko/imageloader/cache/memory/WeakMemoryCache;", "(ILcom/seiko/imageloader/cache/memory/WeakMemoryCache;)V", "cache", "com/seiko/imageloader/cache/memory/RealStrongMemoryCache$cache$1", "Lcom/seiko/imageloader/cache/memory/RealStrongMemoryCache$cache$1;", "keys", "", "", "Lcom/seiko/imageloader/cache/memory/MemoryKey;", "getKeys", "()Ljava/util/Set;", "getMaxSize", "()I", "size", "getSize", "clearMemory", "", "get", "Landroid/graphics/Bitmap;", "Lcom/seiko/imageloader/cache/memory/MemoryValue;", "key", "remove", "", "set", "image", "Lcom/seiko/imageloader/Bitmap;", "extras", "", "", "InternalValue", "image-loader_debug"})
public final class RealStrongMemoryCache
implements StrongMemoryCache {
    @NotNull
    private final WeakMemoryCache weakMemoryCache;
    @NotNull
    private final cache.1 cache;

    public RealStrongMemoryCache(int maxSize, @NotNull WeakMemoryCache weakMemoryCache) {
        Intrinsics.checkNotNullParameter((Object)weakMemoryCache, (String)"weakMemoryCache");
        this.weakMemoryCache = weakMemoryCache;
        this.cache = new LruCache<String, InternalValue>(maxSize, this){
            final /* synthetic */ RealStrongMemoryCache this$0;
            {
                this.this$0 = $receiver;
                super($maxSize);
            }

            protected int sizeOf(@NotNull String key, @NotNull InternalValue value) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getSize();
            }

            protected void entryRemoved(boolean evicted, @NotNull String key, @NotNull InternalValue oldValue, @Nullable InternalValue newValue) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                RealStrongMemoryCache.access$getWeakMemoryCache$p(this.this$0).set(key, oldValue.getImage(), oldValue.getExtras(), oldValue.getSize());
            }
        };
    }

    @Override
    public int getSize() {
        return this.cache.getSize();
    }

    @Override
    public int getMaxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    @NotNull
    public Set<String> getKeys() {
        return this.cache.snapshot().keySet();
    }

    @Override
    @Nullable
    public Bitmap get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        InternalValue internalValue = (InternalValue)this.cache.get(key);
        return internalValue != null ? internalValue.getImage() : null;
    }

    @Override
    public void set(@NotNull String key, @NotNull Bitmap image, @NotNull Map<String, ? extends Object> extras) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter(extras, (String)"extras");
        int size2 = Bitmap_androidKt.getSize(image);
        if (size2 <= this.getMaxSize()) {
            this.cache.put(key, new InternalValue(image, extras, size2));
        } else {
            this.cache.remove(key);
            this.weakMemoryCache.set(key, image, extras, size2);
        }
    }

    @Override
    public boolean remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.cache.remove(key) != null;
    }

    @Override
    public void clearMemory() {
        this.cache.evictAll();
    }

    public static final /* synthetic */ WeakMemoryCache access$getWeakMemoryCache$p(RealStrongMemoryCache $this) {
        return $this.weakMemoryCache;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B-\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/seiko/imageloader/cache/memory/RealStrongMemoryCache$InternalValue;", "", "image", "Landroid/graphics/Bitmap;", "Lcom/seiko/imageloader/Bitmap;", "extras", "", "", "size", "", "(Landroid/graphics/Bitmap;Ljava/util/Map;I)V", "getExtras", "()Ljava/util/Map;", "getImage", "()Landroid/graphics/Bitmap;", "getSize", "()I", "image-loader_debug"})
    private static final class InternalValue {
        @NotNull
        private final Bitmap image;
        @NotNull
        private final Map<String, Object> extras;
        private final int size;

        public InternalValue(@NotNull Bitmap image, @NotNull Map<String, ? extends Object> extras, int size2) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Intrinsics.checkNotNullParameter(extras, (String)"extras");
            this.image = image;
            this.extras = extras;
            this.size = size2;
        }

        @NotNull
        public final Bitmap getImage() {
            return this.image;
        }

        @NotNull
        public final Map<String, Object> getExtras() {
            return this.extras;
        }

        public final int getSize() {
            return this.size;
        }
    }
}

