/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.component.decoder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import androidx.compose.runtime.internal.StabilityInferred;
import com.seiko.imageloader.component.decoder.BitmapFactoryDecoder;
import com.seiko.imageloader.component.decoder.DecodeResult;
import com.seiko.imageloader.component.decoder.Decoder;
import com.seiko.imageloader.model.ImageResult;
import com.seiko.imageloader.option.Options;
import com.seiko.imageloader.util.BitmapKt;
import com.seiko.imageloader.util.DecodeUtils;
import com.seiko.imageloader.util.ExifData;
import com.seiko.imageloader.util.ExifUtils;
import com.seiko.imageloader.util.ExifUtilsKt;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcom/seiko/imageloader/component/decoder/BitmapFactoryDecoder;", "Lcom/seiko/imageloader/component/decoder/Decoder;", "context", "Landroid/content/Context;", "source", "Lcom/seiko/imageloader/model/ImageResult$Source;", "Lcom/seiko/imageloader/component/decoder/DecodeSource;", "options", "Lcom/seiko/imageloader/option/Options;", "maxImageSize", "", "parallelismLock", "Lkotlinx/coroutines/sync/Semaphore;", "(Landroid/content/Context;Lcom/seiko/imageloader/model/ImageResult$Source;Lcom/seiko/imageloader/option/Options;ILkotlinx/coroutines/sync/Semaphore;)V", "decode", "Lcom/seiko/imageloader/component/decoder/DecodeResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "configureConfig", "", "Landroid/graphics/BitmapFactory$Options;", "exifData", "Lcom/seiko/imageloader/util/ExifData;", "configureScale", "Companion", "ExceptionCatchingSource", "Factory", "image-loader_debug"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBitmapFactoryDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapFactoryDecoder.kt\ncom/seiko/imageloader/component/decoder/BitmapFactoryDecoder\n+ 2 Semaphore.kt\nkotlinx/coroutines/sync/SemaphoreKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n81#2,9:201\n1#3:210\n*S KotlinDebug\n*F\n+ 1 BitmapFactoryDecoder.kt\ncom/seiko/imageloader/component/decoder/BitmapFactoryDecoder\n*L\n34#1:201,9\n*E\n"})
public final class BitmapFactoryDecoder
implements Decoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final ImageResult.Source source;
    @NotNull
    private final Options options;
    private final int maxImageSize;
    @NotNull
    private final Semaphore parallelismLock;
    public static final int $stable = 8;
    public static final int DEFAULT_MAX_PARALLELISM = 4;

    private BitmapFactoryDecoder(Context context, ImageResult.Source source, Options options, int maxImageSize, Semaphore parallelismLock) {
        this.context = context;
        this.source = source;
        this.options = options;
        this.maxImageSize = maxImageSize;
        this.parallelismLock = parallelismLock;
    }

    /* synthetic */ BitmapFactoryDecoder(Context context, ImageResult.Source source, Options options, int n, Semaphore semaphore, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            semaphore = SemaphoreKt.Semaphore$default((int)Integer.MAX_VALUE, (int)0, (int)2, null);
        }
        this(context, source, options, n, semaphore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object decode(@NotNull Continuation<? super DecodeResult> var1_1) {
        if (!(var1_1 instanceof decode.1)) ** GOTO lbl-1000
        var7_2 = var1_1;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ BitmapFactoryDecoder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.decode((Continuation<? super DecodeResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withPermit$iv = this.parallelismLock;
                $i$f$withPermit = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withPermit$iv;
                $continuation.label = 1;
                v0 = $this$withPermit$iv.acquire((Continuation)$continuation);
                if (v0 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl29
            }
            case 1: {
                $i$f$withPermit = false;
                $this$withPermit$iv = (Semaphore)$continuation.L$1;
                this = (BitmapFactoryDecoder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 3 sources

                $i$a$-withPermit-BitmapFactoryDecoder$decode$2 = false;
                $continuation.L$0 = $this$withPermit$iv;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = InterruptibleKt.runInterruptible$default(null, (Function0)((Function0)new Function0<DecodeResult>(this){
                    final /* synthetic */ BitmapFactoryDecoder this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final DecodeResult invoke() {
                        return BitmapFactoryDecoder.access$decode(this.this$0, new BitmapFactory.Options());
                    }
                }), (Continuation)$continuation, (int)1, null);
                ** if (v1 != var8_4) goto lbl37
lbl36:
                // 1 sources

                return var8_4;
lbl37:
                // 1 sources

                ** GOTO lbl46
            }
            case 2: {
                $i$f$withPermit = false;
                $i$a$-withPermit-BitmapFactoryDecoder$decode$2 = false;
                $this$withPermit$iv = (Semaphore)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl46:
                    // 2 sources

                    var5_11 = (DecodeResult)v1;
                }
                catch (Throwable var5_12) {
                    throw var5_12;
                }
                finally {
                    $this$withPermit$iv.release();
                }
                return var5_11;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DecodeResult decode(BitmapFactory.Options $this$decode) {
        Object it4;
        ExceptionCatchingSource safeSource = new ExceptionCatchingSource((Source)this.source.getSource());
        BufferedSource safeBufferedSource = Okio.buffer((Source)((Source)safeSource));
        $this$decode.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)safeBufferedSource.peek().inputStream(), null, (BitmapFactory.Options)$this$decode);
        Exception exception = safeSource.getException();
        if (exception != null) {
            Exception it2 = exception;
            boolean bl = false;
            throw it2;
        }
        $this$decode.inJustDecodeBounds = false;
        ExifData exifData = ExifUtils.INSTANCE.readData($this$decode.outMimeType, safeBufferedSource);
        Exception exception2 = safeSource.getException();
        if (exception2 != null) {
            Exception it3 = exception2;
            boolean bl = false;
            throw it3;
        }
        $this$decode.inMutable = false;
        $this$decode.inPremultiplied = this.options.getPremultipliedAlpha();
        this.configureConfig($this$decode, exifData);
        this.configureScale($this$decode, exifData);
        Closeable it2 = (Closeable)safeBufferedSource;
        Throwable throwable = null;
        try {
            it4 = (BufferedSource)it2;
            boolean bl = false;
            it4 = BitmapFactory.decodeStream((InputStream)it4.inputStream(), null, (BitmapFactory.Options)$this$decode);
        }
        catch (Throwable it4) {
            throwable = it4;
            throw it4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)it2, (Throwable)throwable);
        }
        BufferedSource outBitmap = it4;
        Exception exception3 = safeSource.getException();
        if (exception3 != null) {
            it4 = exception3;
            boolean bl = false;
            throw it4;
        }
        if (outBitmap == null) {
            boolean $i$a$-checkNotNull-BitmapFactoryDecoder$decode$72 = false;
            String $i$a$-checkNotNull-BitmapFactoryDecoder$decode$72 = "BitmapFactory returned a null bitmap. Often this means BitmapFactory could not decode the image data read from the input source (e.g. network, disk, or memory) as it's not encoded as a valid image format.";
            throw new IllegalStateException($i$a$-checkNotNull-BitmapFactoryDecoder$decode$72.toString());
        }
        outBitmap.setDensity(this.context.getResources().getDisplayMetrics().densityDpi);
        Bitmap bitmap = ExifUtils.INSTANCE.reverseTransformations((Bitmap)outBitmap, exifData);
        return new DecodeResult.Bitmap(bitmap);
    }

    private final void configureConfig(BitmapFactory.Options $this$configureConfig, ExifData exifData) {
        Bitmap.Config config = BitmapKt.toBitmapConfig(this.options.getConfig());
        if (exifData.isFlipped() || ExifUtilsKt.isRotated(exifData)) {
            config = BitmapKt.toSoftware(config);
        }
        if (Build.VERSION.SDK_INT >= 26 && $this$configureConfig.outConfig == Bitmap.Config.RGBA_F16 && config != Bitmap.Config.HARDWARE) {
            config = Bitmap.Config.RGBA_F16;
        }
        $this$configureConfig.inPreferredConfig = config;
    }

    private final void configureScale(BitmapFactory.Options $this$configureScale, ExifData exifData) {
        int srcHeight;
        int dstHeight;
        if ($this$configureScale.outWidth <= 0 || $this$configureScale.outHeight <= 0) {
            $this$configureScale.inSampleSize = 1;
            $this$configureScale.inScaled = false;
            return;
        }
        int srcWidth = ExifUtilsKt.isSwapped(exifData) ? $this$configureScale.outHeight : $this$configureScale.outWidth;
        int dstWidth = srcWidth;
        if (Math.max(dstWidth, dstHeight = (srcHeight = ExifUtilsKt.isSwapped(exifData) ? $this$configureScale.outWidth : $this$configureScale.outHeight)) > this.maxImageSize) {
            if (dstWidth >= dstHeight) {
                dstHeight = (int)((float)this.maxImageSize / (float)srcWidth * (float)dstHeight);
                dstWidth = this.maxImageSize;
            } else {
                dstWidth = (int)((float)this.maxImageSize / (float)srcWidth * (float)dstWidth);
                dstHeight = this.maxImageSize;
            }
        }
        $this$configureScale.inSampleSize = DecodeUtils.calculateInSampleSize(srcWidth, srcHeight, dstWidth, dstHeight, this.options.getScale());
        double scale2 = DecodeUtils.computeSizeMultiplier((double)srcWidth / (double)$this$configureScale.inSampleSize, (double)srcHeight / (double)$this$configureScale.inSampleSize, (double)dstWidth, (double)dstHeight, this.options.getScale());
        if (this.options.getAllowInexactSize()) {
            scale2 = RangesKt.coerceAtMost((double)scale2, (double)1.0);
        }
        boolean bl = $this$configureScale.inScaled = !(scale2 == 1.0);
        if ($this$configureScale.inScaled) {
            if (scale2 > 1.0) {
                $this$configureScale.inDensity = MathKt.roundToInt((double)((double)Integer.MAX_VALUE / scale2));
                $this$configureScale.inTargetDensity = Integer.MAX_VALUE;
            } else {
                $this$configureScale.inDensity = Integer.MAX_VALUE;
                $this$configureScale.inTargetDensity = MathKt.roundToInt((double)((double)Integer.MAX_VALUE * scale2));
            }
        }
    }

    public /* synthetic */ BitmapFactoryDecoder(Context context, ImageResult.Source source, Options options, int maxImageSize, Semaphore parallelismLock, DefaultConstructorMarker $constructor_marker) {
        this(context, source, options, maxImageSize, parallelismLock);
    }

    public static final /* synthetic */ DecodeResult access$decode(BitmapFactoryDecoder $this, BitmapFactory.Options $receiver) {
        return $this.decode($receiver);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/seiko/imageloader/component/decoder/BitmapFactoryDecoder$Companion;", "", "()V", "DEFAULT_MAX_PARALLELISM", "", "image-loader_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016R.\u0010\b\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u00072\u000e\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/seiko/imageloader/component/decoder/BitmapFactoryDecoder$ExceptionCatchingSource;", "Lokio/ForwardingSource;", "delegate", "Lokio/Source;", "(Lokio/Source;)V", "<set-?>", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exception", "getException", "()Ljava/lang/Exception;", "read", "", "sink", "Lokio/Buffer;", "byteCount", "image-loader_debug"})
    private static final class ExceptionCatchingSource
    extends ForwardingSource {
        @Nullable
        private Exception exception;

        public ExceptionCatchingSource(@NotNull Source delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(delegate);
        }

        @Nullable
        public final Exception getException() {
            return this.exception;
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            try {
                return super.read(sink, byteCount);
            }
            catch (Exception e) {
                this.exception = e;
                throw e;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J%\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lcom/seiko/imageloader/component/decoder/BitmapFactoryDecoder$Factory;", "Lcom/seiko/imageloader/component/decoder/Decoder$Factory;", "context", "Landroid/content/Context;", "maxImageSize", "", "maxParallelism", "(Landroid/content/Context;II)V", "parallelismLock", "Lkotlinx/coroutines/sync/Semaphore;", "create", "Lcom/seiko/imageloader/component/decoder/Decoder;", "source", "Lcom/seiko/imageloader/model/ImageResult$Source;", "Lcom/seiko/imageloader/component/decoder/DecodeSource;", "options", "Lcom/seiko/imageloader/option/Options;", "(Lcom/seiko/imageloader/model/ImageResult$Source;Lcom/seiko/imageloader/option/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "image-loader_debug"})
    @StabilityInferred(parameters=0)
    public static final class Factory
    implements Decoder.Factory {
        @NotNull
        private final Context context;
        private final int maxImageSize;
        @NotNull
        private final Semaphore parallelismLock;
        public static final int $stable = 8;

        public Factory(@NotNull Context context, int maxImageSize, int maxParallelism) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.maxImageSize = maxImageSize;
            this.parallelismLock = SemaphoreKt.Semaphore$default((int)maxParallelism, (int)0, (int)2, null);
        }

        public /* synthetic */ Factory(Context context, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                n2 = 4;
            }
            this(context, n, n2);
        }

        @Override
        @Nullable
        public Object create(@NotNull ImageResult.Source source, @NotNull Options options, @NotNull Continuation<? super Decoder> $completion) {
            return new BitmapFactoryDecoder(this.context, source, options, this.maxImageSize, this.parallelismLock, null);
        }
    }
}

