/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.component.decoder;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.graphics.drawable.AnimatedImageDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.compose.runtime.internal.StabilityInferred;
import com.seiko.imageloader.Image;
import com.seiko.imageloader.component.decoder.DecodeResult;
import com.seiko.imageloader.component.decoder.Decoder;
import com.seiko.imageloader.component.fetcher.AssetUriFetcher;
import com.seiko.imageloader.component.fetcher.ContentUriFetcher;
import com.seiko.imageloader.component.fetcher.ResourceUriFetcher;
import com.seiko.imageloader.model.ImageResult;
import com.seiko.imageloader.option.Options;
import com.seiko.imageloader.util.BitmapKt;
import com.seiko.imageloader.util.FrameDelayRewritingSource;
import com.seiko.imageloader.util.ScaleDrawable;
import com.seiko.imageloader.util.SourceTypeKt;
import java.io.Closeable;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001aB-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\f\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u0019*\u00060\u0005j\u0002`\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lcom/seiko/imageloader/component/decoder/ImageDecoderDecoder;", "Lcom/seiko/imageloader/component/decoder/Decoder;", "context", "Landroid/content/Context;", "source", "Lcom/seiko/imageloader/model/ImageResult$Source;", "Lcom/seiko/imageloader/component/decoder/DecodeSource;", "options", "Lcom/seiko/imageloader/option/Options;", "enforceMinimumFrameDelay", "", "(Landroid/content/Context;Lcom/seiko/imageloader/model/ImageResult$Source;Lcom/seiko/imageloader/option/Options;Z)V", "decode", "Lcom/seiko/imageloader/component/decoder/DecodeResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "wrapBufferedSource", "Lokio/BufferedSource;", "channel", "wrapDrawable", "Landroid/graphics/drawable/Drawable;", "baseDrawable", "configureImageDecoderProperties", "", "Landroid/graphics/ImageDecoder;", "toImageDecoderSource", "Landroid/graphics/ImageDecoder$Source;", "Factory", "image-loader_debug"})
@RequiresApi(value=28)
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nImageDecoderDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageDecoderDecoder.kt\ncom/seiko/imageloader/component/decoder/ImageDecoderDecoder\n+ 2 ImageDecoder.kt\nandroidx/core/graphics/ImageDecoderKt\n+ 3 Image.android.kt\ncom/seiko/imageloader/Image_androidKt\n+ 4 ExtraData.kt\ncom/seiko/imageloader/model/ExtraDataKt\n+ 5 DiskCacheBuilder.android.kt\ncom/seiko/imageloader/cache/disk/DiskCacheBuilder_androidKt\n+ 6 FileSystem.kt\nokio/FileSystem\n+ 7 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,161:1\n52#2:162\n17#3:163\n25#4:164\n8#5:165\n79#6:166\n160#6:167\n80#6:168\n81#6:174\n52#7,5:169\n60#7,7:175\n57#7,13:182\n*S KotlinDebug\n*F\n+ 1 ImageDecoderDecoder.kt\ncom/seiko/imageloader/component/decoder/ImageDecoderDecoder\n*L\n50#1:162\n61#1:163\n76#1:164\n97#1:165\n97#1:166\n97#1:167\n97#1:168\n97#1:174\n97#1:169,5\n97#1:175,7\n97#1:182,13\n*E\n"})
public final class ImageDecoderDecoder
implements Decoder {
    @NotNull
    private final Context context;
    @NotNull
    private final ImageResult.Source source;
    @NotNull
    private final Options options;
    private final boolean enforceMinimumFrameDelay;
    public static final int $stable = 8;

    private ImageDecoderDecoder(Context context, ImageResult.Source source, Options options, boolean enforceMinimumFrameDelay) {
        this.context = context;
        this.source = source;
        this.options = options;
        this.enforceMinimumFrameDelay = enforceMinimumFrameDelay;
    }

    /* synthetic */ ImageDecoderDecoder(Context context, ImageResult.Source source, Options options, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(context, source, options, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object decode(@NotNull Continuation<? super DecodeResult> $completion) {
        ImageDecoder.Source $this$decodeDrawable$iv;
        Ref.ObjectRef imageDecoder = new Ref.ObjectRef();
        try {
            $this$decodeDrawable$iv = this.toImageDecoderSource(this.source);
            boolean $i$f$decodeDrawable = false;
            Drawable drawable = ImageDecoder.decodeDrawable((ImageDecoder.Source)$this$decodeDrawable$iv, (ImageDecoder.OnHeaderDecodedListener)new ImageDecoder.OnHeaderDecodedListener(imageDecoder, this){
                final /* synthetic */ Ref.ObjectRef $imageDecoder$inlined;
                final /* synthetic */ ImageDecoderDecoder this$0;
                {
                    this.$imageDecoder$inlined = objectRef;
                    this.this$0 = imageDecoderDecoder;
                }

                public final void onHeaderDecoded(@NotNull ImageDecoder decoder, @NotNull ImageDecoder.ImageInfo info, @NotNull ImageDecoder.Source source) {
                    Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
                    Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    ImageDecoder $this$decode_u24lambda_u240 = decoder;
                    boolean bl = false;
                    this.$imageDecoder$inlined.element = $this$decode_u24lambda_u240;
                    ImageDecoderDecoder.access$configureImageDecoderProperties(this.this$0, $this$decode_u24lambda_u240);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"crossinline action: Imag\u2026ction(info, source)\n    }");
            $this$decodeDrawable$iv = drawable;
        }
        finally {
            ImageDecoder imageDecoder2 = (ImageDecoder)imageDecoder.element;
            if (imageDecoder2 != null) {
                imageDecoder2.close();
            }
        }
        ImageDecoder.Source drawable = $this$decodeDrawable$iv;
        Drawable $this$toImage$iv = this.wrapDrawable((Drawable)drawable);
        boolean $i$f$toImage = false;
        return new DecodeResult.Image(new Image($this$toImage$iv));
    }

    private final BufferedSource wrapBufferedSource(BufferedSource channel) {
        BufferedSource bufferedSource;
        if (this.enforceMinimumFrameDelay && SourceTypeKt.isGif(channel)) {
            FrameDelayRewritingSource rewritingSource = new FrameDelayRewritingSource((Source)channel);
            bufferedSource = Okio.buffer((Source)((Source)rewritingSource));
        } else {
            bufferedSource = channel;
        }
        return bufferedSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    private final ImageDecoder.Source toImageDecoderSource(ImageResult.Source $this$toImageDecoderSource) {
        ImageDecoder.Source source;
        block20: {
            Throwable thrown$iv$iv;
            Long result$iv$iv;
            File temp;
            block18: {
                void $this$iv;
                BufferedSource source2;
                block21: {
                    block19: {
                        Map<String, Object> $this$metadata$iv = $this$toImageDecoderSource.getExtra();
                        boolean $i$f$getMetadata = false;
                        Object metadata = $this$metadata$iv.get("KEY_META_DATA");
                        if (metadata instanceof AssetUriFetcher.MetaData) {
                            ImageDecoder.Source source3 = ImageDecoder.createSource((AssetManager)this.context.getAssets(), (String)((AssetUriFetcher.MetaData)metadata).getFileName());
                            Intrinsics.checkNotNullExpressionValue((Object)source3, (String)"createSource(context.assets, metadata.fileName)");
                            return source3;
                        }
                        if (metadata instanceof ContentUriFetcher.Metadata) {
                            ImageDecoder.Source source4 = ImageDecoder.createSource((ContentResolver)this.context.getContentResolver(), (Uri)((ContentUriFetcher.Metadata)metadata).getUri());
                            Intrinsics.checkNotNullExpressionValue((Object)source4, (String)"createSource(context.con\u2026ntResolver, metadata.uri)");
                            return source4;
                        }
                        if (metadata instanceof ResourceUriFetcher.Metadata && Intrinsics.areEqual((Object)((ResourceUriFetcher.Metadata)metadata).getPackageName(), (Object)this.context.getPackageName())) {
                            ImageDecoder.Source source5 = ImageDecoder.createSource((Resources)this.context.getResources(), (int)((ResourceUriFetcher.Metadata)metadata).getResId());
                            Intrinsics.checkNotNullExpressionValue((Object)source5, (String)"createSource(context.resources, metadata.resId)");
                            return source5;
                        }
                        source2 = this.wrapBufferedSource($this$toImageDecoderSource.getSource());
                        if (Build.VERSION.SDK_INT < 31) break block19;
                        ImageDecoder.Source source6 = ImageDecoder.createSource((byte[])source2.readByteArray());
                        source = source6;
                        Intrinsics.checkNotNullExpressionValue((Object)source6, (String)"createSource(source.readByteArray())");
                        break block20;
                    }
                    if (Build.VERSION.SDK_INT != 30) break block21;
                    ImageDecoder.Source source7 = ImageDecoder.createSource((ByteBuffer)ByteBuffer.wrap(source2.readByteArray()));
                    source = source7;
                    Intrinsics.checkNotNullExpressionValue((Object)source7, (String)"createSource(ByteBuffer.\u2026(source.readByteArray()))");
                    break block20;
                }
                temp = File.createTempFile("tmp", null);
                boolean $i$f$getSystemFileSystem2333333332 = false;
                FileSystem $i$f$getSystemFileSystem2333333332 = FileSystem.SYSTEM;
                Intrinsics.checkNotNullExpressionValue((Object)temp, (String)"temp");
                Path file$iv = Path.Companion.get$default((Path.Companion)Path.Companion, (File)temp, (boolean)false, (int)1, null);
                boolean mustCreate$iv = false;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                result$iv$iv = null;
                thrown$iv$iv = null;
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSink $this$toImageDecoderSource_u24lambda_u241 = it$iv;
                boolean bl3 = false;
                result$iv$iv = $this$toImageDecoderSource_u24lambda_u241.writeAll((Source)source2);
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                    break block18;
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
                break block18;
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                    }
                    catch (Throwable throwable) {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            thrown$iv$iv = t$iv$iv2;
                        }
                        throw throwable;
                    }
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv$iv3) {
                        if (thrown$iv$iv == null) {
                            thrown$iv$iv = t$iv$iv3;
                            break block18;
                        }
                        ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv3);
                    }
                }
            }
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            Intrinsics.checkNotNull((Object)result$iv$iv);
            ImageDecoder.Source source8 = ImageDecoder.createSource((File)temp);
            Intrinsics.checkNotNullExpressionValue((Object)source8, (String)"{\n                val te\u2026ource(temp)\n            }");
            source = source8;
        }
        return source;
    }

    private final void configureImageDecoderProperties(ImageDecoder $this$configureImageDecoderProperties) {
        Bitmap.Config config = BitmapKt.toBitmapConfig(this.options.getConfig());
        $this$configureImageDecoderProperties.setAllocator(BitmapKt.isHardware(config) ? 3 : 1);
        $this$configureImageDecoderProperties.setMemorySizePolicy(1);
        $this$configureImageDecoderProperties.setUnpremultipliedRequired(!this.options.getPremultipliedAlpha());
    }

    private final Drawable wrapDrawable(Drawable baseDrawable) {
        if (!(baseDrawable instanceof AnimatedImageDrawable)) {
            return baseDrawable;
        }
        ((AnimatedImageDrawable)baseDrawable).setRepeatCount(-1);
        return new ScaleDrawable(baseDrawable, this.options.getScale());
    }

    public /* synthetic */ ImageDecoderDecoder(Context context, ImageResult.Source source, Options options, boolean enforceMinimumFrameDelay, DefaultConstructorMarker $constructor_marker) {
        this(context, source, options, enforceMinimumFrameDelay);
    }

    public static final /* synthetic */ void access$configureImageDecoderProperties(ImageDecoderDecoder $this, ImageDecoder $receiver) {
        $this.configureImageDecoderProperties($receiver);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lcom/seiko/imageloader/component/decoder/ImageDecoderDecoder$Factory;", "Lcom/seiko/imageloader/component/decoder/Decoder$Factory;", "context", "Landroid/content/Context;", "enforceMinimumFrameDelay", "", "(Landroid/content/Context;Z)V", "create", "Lcom/seiko/imageloader/component/decoder/Decoder;", "source", "Lcom/seiko/imageloader/model/ImageResult$Source;", "Lcom/seiko/imageloader/component/decoder/DecodeSource;", "options", "Lcom/seiko/imageloader/option/Options;", "(Lcom/seiko/imageloader/model/ImageResult$Source;Lcom/seiko/imageloader/option/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isApplicable", "Lokio/BufferedSource;", "image-loader_debug"})
    @StabilityInferred(parameters=0)
    public static final class Factory
    implements Decoder.Factory {
        @NotNull
        private final Context context;
        private final boolean enforceMinimumFrameDelay;
        public static final int $stable = 8;

        @JvmOverloads
        public Factory(@NotNull Context context, boolean enforceMinimumFrameDelay) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.enforceMinimumFrameDelay = enforceMinimumFrameDelay;
        }

        public /* synthetic */ Factory(Context context, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(context, bl);
        }

        @Override
        @Nullable
        public Object create(@NotNull ImageResult.Source source, @NotNull Options options, @NotNull Continuation<? super Decoder> $completion) {
            if (!this.isApplicable(source.getSource())) {
                return null;
            }
            return new ImageDecoderDecoder(this.context, source, options, this.enforceMinimumFrameDelay, null);
        }

        private final boolean isApplicable(BufferedSource source) {
            return SourceTypeKt.isGif(source) || SourceTypeKt.isAnimatedWebP(source) || Build.VERSION.SDK_INT >= 30 && SourceTypeKt.isAnimatedHeif(source);
        }

        @JvmOverloads
        public Factory(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this(context, false, 2, null);
        }
    }
}

