/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.component.fetcher;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.eygraber.uri.AndroidUriKt;
import com.eygraber.uri.Uri;
import com.seiko.imageloader.component.fetcher.FetchResult;
import com.seiko.imageloader.component.fetcher.Fetcher;
import com.seiko.imageloader.model.ExtraDataKt;
import com.seiko.imageloader.option.Options;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\bH\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\fJ\u0015\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lcom/seiko/imageloader/component/fetcher/ContentUriFetcher;", "Lcom/seiko/imageloader/component/fetcher/Fetcher;", "context", "Landroid/content/Context;", "data", "Lcom/eygraber/uri/Uri;", "(Landroid/content/Context;Lcom/eygraber/uri/Uri;)V", "fetch", "Lcom/seiko/imageloader/component/fetcher/FetchResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isContactPhotoUri", "", "isContactPhotoUri$image_loader_debug", "isMusicThumbnailUri", "isMusicThumbnailUri$image_loader_debug", "Factory", "Metadata", "image-loader_debug"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nContentUriFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentUriFetcher.kt\ncom/seiko/imageloader/component/fetcher/ContentUriFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class ContentUriFetcher
implements Fetcher {
    @NotNull
    private final Context context;
    @NotNull
    private final Uri data;
    public static final int $stable = 8;

    private ContentUriFetcher(Context context, Uri data) {
        this.context = context;
        this.data = data;
    }

    @Override
    @SuppressLint(value={"Recycle"})
    @Nullable
    public Object fetch(@NotNull Continuation<? super FetchResult> $completion) {
        InputStream inputStream;
        InputStream stream;
        ContentResolver contentResolver = this.context.getContentResolver();
        android.net.Uri androidUri = AndroidUriKt.toAndroidUri((Uri)this.data);
        if (this.isContactPhotoUri$image_loader_debug(this.data)) {
            AssetFileDescriptor assetFileDescriptor = contentResolver.openAssetFileDescriptor(androidUri, "r");
            InputStream inputStream2 = stream = assetFileDescriptor != null ? assetFileDescriptor.createInputStream() : null;
            if (inputStream2 == null) {
                boolean $i$a$-checkNotNull-ContentUriFetcher$fetch$inputStream$42 = false;
                String $i$a$-checkNotNull-ContentUriFetcher$fetch$inputStream$42 = "Unable to find a contact photo associated with '" + this.data + "'.";
                throw new IllegalStateException($i$a$-checkNotNull-ContentUriFetcher$fetch$inputStream$42.toString());
            }
            inputStream = inputStream2;
        } else if (Build.VERSION.SDK_INT >= 29 && this.isMusicThumbnailUri$image_loader_debug(this.data)) {
            AssetFileDescriptor $i$a$-checkNotNull-ContentUriFetcher$fetch$inputStream$42 = contentResolver.openTypedAssetFile(androidUri, "image/*", null, null);
            InputStream inputStream3 = stream = $i$a$-checkNotNull-ContentUriFetcher$fetch$inputStream$42 != null ? $i$a$-checkNotNull-ContentUriFetcher$fetch$inputStream$42.createInputStream() : null;
            if (inputStream3 == null) {
                boolean $i$a$-checkNotNull-ContentUriFetcher$fetch$inputStream$52 = false;
                String $i$a$-checkNotNull-ContentUriFetcher$fetch$inputStream$52 = "Unable to find a music thumbnail associated with '" + this.data + "'.";
                throw new IllegalStateException($i$a$-checkNotNull-ContentUriFetcher$fetch$inputStream$52.toString());
            }
            inputStream = inputStream3;
        } else {
            stream = contentResolver.openInputStream(androidUri);
            inputStream = stream;
            if (inputStream == null) {
                boolean bl = false;
                String string = "Unable to open '" + this.data + "'.";
                throw new IllegalStateException(string.toString());
            }
        }
        InputStream inputStream4 = inputStream;
        return new FetchResult.Source(Okio.buffer((Source)Okio.source((InputStream)inputStream4)), ExtraDataKt.extraData((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(contentResolver, androidUri){
            final /* synthetic */ ContentResolver $contentResolver;
            final /* synthetic */ android.net.Uri $androidUri;
            {
                this.$contentResolver = $contentResolver;
                this.$androidUri = $androidUri;
                super(1);
            }

            public final void invoke(@NotNull Map<String, Object> $this$extraData) {
                Intrinsics.checkNotNullParameter($this$extraData, (String)"$this$extraData");
                ExtraDataKt.mimeType($this$extraData, this.$contentResolver.getType(this.$androidUri));
                ExtraDataKt.metadata($this$extraData, new Metadata(this.$androidUri));
            }
        })));
    }

    @VisibleForTesting
    public final boolean isContactPhotoUri$image_loader_debug(@NotNull Uri data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return Intrinsics.areEqual((Object)data.getAuthority(), (Object)"com.android.contacts") && Intrinsics.areEqual((Object)data.getLastPathSegment(), (Object)"display_photo");
    }

    @VisibleForTesting
    public final boolean isMusicThumbnailUri$image_loader_debug(@NotNull Uri data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!Intrinsics.areEqual((Object)data.getAuthority(), (Object)"media")) {
            return false;
        }
        List segments = data.getPathSegments();
        int size2 = segments.size();
        return size2 >= 3 && Intrinsics.areEqual(segments.get(size2 - 3), (Object)"audio") && Intrinsics.areEqual(segments.get(size2 - 2), (Object)"albums");
    }

    public /* synthetic */ ContentUriFetcher(Context context, Uri data, DefaultConstructorMarker $constructor_marker) {
        this(context, data);
    }

    @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/seiko/imageloader/component/fetcher/ContentUriFetcher$Factory;", "Lcom/seiko/imageloader/component/fetcher/Fetcher$Factory;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "create", "Lcom/seiko/imageloader/component/fetcher/Fetcher;", "data", "", "options", "Lcom/seiko/imageloader/option/Options;", "isApplicable", "", "Lcom/eygraber/uri/Uri;", "image-loader_debug"})
    @StabilityInferred(parameters=0)
    public static final class Factory
    implements Fetcher.Factory {
        @NotNull
        private final Context context;
        public static final int $stable = 8;

        public Factory(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        @Override
        @Nullable
        public Fetcher create(@NotNull Object data, @NotNull Options options) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            if (!(data instanceof Uri)) {
                return null;
            }
            if (!this.isApplicable((Uri)data)) {
                return null;
            }
            return new ContentUriFetcher(this.context, (Uri)data, null);
        }

        private final boolean isApplicable(Uri data) {
            return Intrinsics.areEqual((Object)data.getScheme(), (Object)"content");
        }
    }

    @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/seiko/imageloader/component/fetcher/ContentUriFetcher$Metadata;", "", "uri", "Landroid/net/Uri;", "(Landroid/net/Uri;)V", "getUri", "()Landroid/net/Uri;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "image-loader_debug"})
    @StabilityInferred(parameters=0)
    public static final class Metadata {
        @NotNull
        private final android.net.Uri uri;
        public static final int $stable = 8;

        public Metadata(@NotNull android.net.Uri uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.uri = uri;
        }

        @NotNull
        public final android.net.Uri getUri() {
            return this.uri;
        }

        @NotNull
        public final android.net.Uri component1() {
            return this.uri;
        }

        @NotNull
        public final Metadata copy(@NotNull android.net.Uri uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return new Metadata(uri);
        }

        public static /* synthetic */ Metadata copy$default(Metadata metadata, android.net.Uri uri, int n, Object object) {
            if ((n & 1) != 0) {
                uri = metadata.uri;
            }
            return metadata.copy(uri);
        }

        @NotNull
        public String toString() {
            return "Metadata(uri=" + this.uri + ")";
        }

        public int hashCode() {
            return this.uri.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Metadata)) {
                return false;
            }
            Metadata metadata = (Metadata)other;
            return Intrinsics.areEqual((Object)this.uri, (Object)metadata.uri);
        }
    }
}

