/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.component.fetcher;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.util.TypedValue;
import android.webkit.MimeTypeMap;
import androidx.annotation.DrawableRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.eygraber.uri.Uri;
import com.seiko.imageloader.Image;
import com.seiko.imageloader.component.fetcher.FetchResult;
import com.seiko.imageloader.component.fetcher.Fetcher;
import com.seiko.imageloader.component.fetcher.ResourceUriFetcherKt;
import com.seiko.imageloader.model.ExtraDataKt;
import com.seiko.imageloader.option.Options;
import com.seiko.imageloader.util.BitmapKt;
import com.seiko.imageloader.util.DrawableUtils;
import com.seiko.imageloader.util.MimeTypeKt;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Lcom/seiko/imageloader/component/fetcher/ResourceUriFetcher;", "Lcom/seiko/imageloader/component/fetcher/Fetcher;", "context", "Landroid/content/Context;", "data", "Lcom/eygraber/uri/Uri;", "options", "Lcom/seiko/imageloader/option/Options;", "(Landroid/content/Context;Lcom/eygraber/uri/Uri;Lcom/seiko/imageloader/option/Options;)V", "isVector", "", "Landroid/graphics/drawable/Drawable;", "(Landroid/graphics/drawable/Drawable;)Z", "fetch", "Lcom/seiko/imageloader/component/fetcher/FetchResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "throwInvalidUriException", "", "Companion", "Factory", "Metadata", "image-loader_debug"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nResourceUriFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceUriFetcher.kt\ncom/seiko/imageloader/component/fetcher/ResourceUriFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Image.android.kt\ncom/seiko/imageloader/Image_androidKt\n*L\n1#1,180:1\n1#2:181\n17#3:182\n*S KotlinDebug\n*F\n+ 1 ResourceUriFetcher.kt\ncom/seiko/imageloader/component/fetcher/ResourceUriFetcher\n*L\n78#1:182\n*E\n"})
public final class ResourceUriFetcher
implements Fetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Uri data;
    @NotNull
    private final Options options;
    public static final int $stable = 8;
    @NotNull
    private static final String MIME_TYPE_XML = "text/xml";

    private ResourceUriFetcher(Context context, Uri data, Options options) {
        this.context = context;
        this.data = data;
        this.options = options;
    }

    @Override
    @Nullable
    public Object fetch(@NotNull Continuation<? super FetchResult> $completion) {
        FetchResult fetchResult;
        String it;
        String string;
        block13: {
            block12: {
                String string2;
                string = this.data.getAuthority();
                if (string == null) break block12;
                it = string2 = string;
                boolean bl = false;
                string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
                if (string != null) break block13;
            }
            this.throwInvalidUriException(this.data);
            throw new KotlinNothingValueException();
        }
        String packageName = string;
        Object object = (String)CollectionsKt.lastOrNull((List)this.data.getPathSegments());
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            this.throwInvalidUriException(this.data);
            throw new KotlinNothingValueException();
        }
        int resId = (Integer)object;
        Resources resources = Intrinsics.areEqual((Object)packageName, (Object)this.context.getPackageName()) ? this.context.getResources() : this.context.getPackageManager().getResourcesForApplication(packageName);
        it = new TypedValue();
        CharSequence $this$fetch_u24lambda_u241 = it;
        int n = 0;
        resources.getValue(resId, (TypedValue)$this$fetch_u24lambda_u241, true);
        CharSequence path = ((TypedValue)it).string;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        $this$fetch_u24lambda_u241 = path;
        n = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        int n2 = $this$fetch_u24lambda_u241.length();
        String entryName = ((Object)$this$fetch_u24lambda_u241.subSequence(n, n2)).toString();
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        Intrinsics.checkNotNullExpressionValue((Object)mimeTypeMap, (String)"getSingleton()");
        String mimeType = MimeTypeKt.getMimeTypeFromUrl(mimeTypeMap, entryName);
        if (Intrinsics.areEqual((Object)mimeType, (Object)MIME_TYPE_XML)) {
            Drawable drawable;
            if (Intrinsics.areEqual((Object)packageName, (Object)this.context.getPackageName())) {
                drawable = ResourceUriFetcherKt.access$getDrawableCompat(this.context, resId);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
                drawable = ResourceUriFetcherKt.access$getXmlDrawableCompat(this.context, resources, resId);
            }
            Drawable drawable2 = drawable;
            boolean isVector = this.isVector(drawable2);
            if (isVector) {
                fetchResult = new FetchResult.Bitmap(DrawableUtils.INSTANCE.convertToBitmap(drawable2, BitmapKt.toBitmapConfig(this.options.getConfig()), this.options.getScale(), this.options.getAllowInexactSize()));
            } else if (drawable2 instanceof BitmapDrawable) {
                Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"drawable.bitmap");
                fetchResult = new FetchResult.Bitmap(bitmap);
            } else {
                Drawable $this$toImage$iv = drawable2;
                boolean $i$f$toImage = false;
                fetchResult = new FetchResult.Image(new Image($this$toImage$iv));
            }
        } else {
            TypedValue typedValue = new TypedValue();
            InputStream inputStream = resources.openRawResource(resId, typedValue);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"resources.openRawResource(resId, typedValue)");
            InputStream inputStream2 = inputStream;
            fetchResult = new FetchResult.Source(Okio.buffer((Source)Okio.source((InputStream)inputStream2)), ExtraDataKt.extraData((Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(mimeType, packageName, resId, typedValue){
                final /* synthetic */ String $mimeType;
                final /* synthetic */ String $packageName;
                final /* synthetic */ int $resId;
                final /* synthetic */ TypedValue $typedValue;
                {
                    this.$mimeType = $mimeType;
                    this.$packageName = $packageName;
                    this.$resId = $resId;
                    this.$typedValue = $typedValue;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> $this$extraData) {
                    Intrinsics.checkNotNullParameter($this$extraData, (String)"$this$extraData");
                    ExtraDataKt.mimeType($this$extraData, this.$mimeType);
                    ExtraDataKt.metadata($this$extraData, new Metadata(this.$packageName, this.$resId, this.$typedValue.density));
                }
            })));
        }
        return fetchResult;
    }

    private final boolean isVector(Drawable $this$isVector) {
        return $this$isVector instanceof VectorDrawable || $this$isVector instanceof VectorDrawableCompat;
    }

    private final Void throwInvalidUriException(Uri data) {
        throw new IllegalStateException("Invalid android.resource URI: " + data);
    }

    public /* synthetic */ ResourceUriFetcher(Context context, Uri data, Options options, DefaultConstructorMarker $constructor_marker) {
        this(context, data, options);
    }

    @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/seiko/imageloader/component/fetcher/ResourceUriFetcher$Companion;", "", "()V", "MIME_TYPE_XML", "", "image-loader_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/seiko/imageloader/component/fetcher/ResourceUriFetcher$Factory;", "Lcom/seiko/imageloader/component/fetcher/Fetcher$Factory;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "create", "Lcom/seiko/imageloader/component/fetcher/Fetcher;", "data", "", "options", "Lcom/seiko/imageloader/option/Options;", "isApplicable", "", "Lcom/eygraber/uri/Uri;", "image-loader_debug"})
    @StabilityInferred(parameters=0)
    public static final class Factory
    implements Fetcher.Factory {
        @NotNull
        private final Context context;
        public static final int $stable = 8;

        public Factory(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        @Override
        @Nullable
        public Fetcher create(@NotNull Object data, @NotNull Options options) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            if (!(data instanceof Uri)) {
                return null;
            }
            if (!this.isApplicable((Uri)data)) {
                return null;
            }
            return new ResourceUriFetcher(this.context, (Uri)data, options, null);
        }

        private final boolean isApplicable(Uri data) {
            return Intrinsics.areEqual((Object)data.getScheme(), (Object)"android.resource");
        }
    }

    @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/seiko/imageloader/component/fetcher/ResourceUriFetcher$Metadata;", "", "packageName", "", "resId", "", "density", "(Ljava/lang/String;II)V", "getDensity", "()I", "getPackageName", "()Ljava/lang/String;", "getResId", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "image-loader_debug"})
    @StabilityInferred(parameters=0)
    public static final class Metadata {
        @NotNull
        private final String packageName;
        private final int resId;
        private final int density;
        public static final int $stable;

        public Metadata(@NotNull String packageName, @DrawableRes int resId, int density) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            this.packageName = packageName;
            this.resId = resId;
            this.density = density;
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        public final int getResId() {
            return this.resId;
        }

        public final int getDensity() {
            return this.density;
        }

        @NotNull
        public final String component1() {
            return this.packageName;
        }

        public final int component2() {
            return this.resId;
        }

        public final int component3() {
            return this.density;
        }

        @NotNull
        public final Metadata copy(@NotNull String packageName, @DrawableRes int resId, int density) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            return new Metadata(packageName, resId, density);
        }

        public static /* synthetic */ Metadata copy$default(Metadata metadata, String string, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = metadata.packageName;
            }
            if ((n3 & 2) != 0) {
                n = metadata.resId;
            }
            if ((n3 & 4) != 0) {
                n2 = metadata.density;
            }
            return metadata.copy(string, n, n2);
        }

        @NotNull
        public String toString() {
            return "Metadata(packageName=" + this.packageName + ", resId=" + this.resId + ", density=" + this.density + ")";
        }

        public int hashCode() {
            int result = this.packageName.hashCode();
            result = result * 31 + Integer.hashCode(this.resId);
            result = result * 31 + Integer.hashCode(this.density);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Metadata)) {
                return false;
            }
            Metadata metadata = (Metadata)other;
            if (!Intrinsics.areEqual((Object)this.packageName, (Object)metadata.packageName)) {
                return false;
            }
            if (this.resId != metadata.resId) {
                return false;
            }
            return this.density == metadata.density;
        }
    }
}

