/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.component.keyer;

import android.content.Context;
import android.content.res.Configuration;
import androidx.compose.runtime.internal.StabilityInferred;
import com.eygraber.uri.Uri;
import com.seiko.imageloader.component.keyer.Keyer;
import com.seiko.imageloader.option.Options;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/seiko/imageloader/component/keyer/UriKeyer;", "Lcom/seiko/imageloader/component/keyer/Keyer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "nightMode", "", "Landroid/content/res/Configuration;", "getNightMode", "(Landroid/content/res/Configuration;)I", "key", "", "data", "", "options", "Lcom/seiko/imageloader/option/Options;", "image-loader_debug"})
@StabilityInferred(parameters=0)
public final class UriKeyer
implements Keyer {
    @NotNull
    private final Context context;
    public static final int $stable = 8;

    public UriKeyer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @Nullable
    public String key(@NotNull Object data, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!(data instanceof Uri)) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)((Uri)data).getScheme(), (Object)"android.resource")) {
            return data.toString();
        }
        Object object = (String)CollectionsKt.lastOrNull((List)((Uri)data).getPathSegments());
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            return data.toString();
        }
        int resId = (Integer)object;
        String entryName = this.context.getResources().getResourceEntryName(resId);
        Uri newUri = ((Uri)data).buildUpon().path(entryName).build();
        Configuration configuration = this.context.getResources().getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"context.resources.configuration");
        return newUri + "-" + this.getNightMode(configuration);
    }

    private final int getNightMode(Configuration $this$nightMode) {
        return $this$nightMode.uiMode & 0x30;
    }
}

