/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.component.mapper;

import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.DrawableRes;
import androidx.compose.runtime.internal.StabilityInferred;
import com.eygraber.uri.Uri;
import com.seiko.imageloader.component.mapper.Mapper;
import com.seiko.imageloader.option.Options;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/seiko/imageloader/component/mapper/ResourceIntMapper;", "Lcom/seiko/imageloader/component/mapper/Mapper;", "Lcom/eygraber/uri/Uri;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isApplicable", "", "data", "", "map", "", "options", "Lcom/seiko/imageloader/option/Options;", "image-loader_debug"})
@StabilityInferred(parameters=0)
public final class ResourceIntMapper
implements Mapper<Uri> {
    @NotNull
    private final Context context;
    public static final int $stable = 8;

    public ResourceIntMapper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @Nullable
    public Uri map(@NotNull Object data, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!(data instanceof Integer)) {
            return null;
        }
        if (!this.isApplicable(((Number)data).intValue(), this.context)) {
            return null;
        }
        return Uri.Companion.parse("android.resource://" + this.context.getPackageName() + "/" + data);
    }

    private final boolean isApplicable(@DrawableRes int data, Context context) {
        boolean bl;
        try {
            bl = context.getResources().getResourceEntryName(data) != null;
        }
        catch (Resources.NotFoundException notFoundException) {
            bl = false;
        }
        return bl;
    }
}

