/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.component.mapper;

import android.content.Context;
import android.content.res.Resources;
import androidx.compose.runtime.internal.StabilityInferred;
import com.eygraber.uri.Uri;
import com.seiko.imageloader.component.mapper.Mapper;
import com.seiko.imageloader.option.Options;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/seiko/imageloader/component/mapper/ResourceUriMapper;", "Lcom/seiko/imageloader/component/mapper/Mapper;", "Lcom/eygraber/uri/Uri;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isApplicable", "", "data", "map", "", "options", "Lcom/seiko/imageloader/option/Options;", "image-loader_debug"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nResourceUriMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceUriMapper.kt\ncom/seiko/imageloader/component/mapper/ResourceUriMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1#2:35\n*E\n"})
public final class ResourceUriMapper
implements Mapper<Uri> {
    @NotNull
    private final Context context;
    public static final int $stable = 8;

    public ResourceUriMapper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @Nullable
    public Uri map(@NotNull Object data, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!(data instanceof Uri)) {
            return null;
        }
        if (!this.isApplicable((Uri)data)) {
            return null;
        }
        String string = ((Uri)data).getAuthority();
        if (string == null) {
            string = "";
        }
        String packageName = string;
        Resources resources = this.context.getPackageManager().getResourcesForApplication(packageName);
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.packageManager.g\u2026rApplication(packageName)");
        Resources resources2 = resources;
        List list = ((Uri)data).getPathSegments();
        String type = (String)list.get(0);
        String name = (String)list.get(1);
        int id = resources2.getIdentifier(name, type, packageName);
        if (!(id != 0)) {
            boolean bl = false;
            String string2 = "Invalid android.resource URI: " + data;
            throw new IllegalStateException(string2.toString());
        }
        return Uri.Companion.parse("android.resource://" + packageName + "/" + id);
    }

    private final boolean isApplicable(Uri data) {
        CharSequence charSequence;
        return Intrinsics.areEqual((Object)data.getScheme(), (Object)"android.resource") && !((charSequence = (CharSequence)data.getAuthority()) == null || StringsKt.isBlank((CharSequence)charSequence)) && ((Collection)data.getPathSegments()).size() == 2;
    }
}

