/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.util;

import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import com.seiko.imageloader.option.Options;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\b\u001a\u00020\u0002*\u00020\tH\u0000\u001a\u000e\u0010\n\u001a\u00020\u0002*\u0004\u0018\u00010\u0002H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0002*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"isHardware", "", "Landroid/graphics/Bitmap$Config;", "(Landroid/graphics/Bitmap$Config;)Z", "safeConfig", "Landroid/graphics/Bitmap;", "getSafeConfig", "(Landroid/graphics/Bitmap;)Landroid/graphics/Bitmap$Config;", "toBitmapConfig", "Lcom/seiko/imageloader/option/Options$ImageConfig;", "toSoftware", "image-loader_debug"})
public final class BitmapKt {
    @NotNull
    public static final Bitmap.Config getSafeConfig(@NotNull Bitmap $this$safeConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$safeConfig, (String)"<this>");
        Bitmap.Config config = $this$safeConfig.getConfig();
        if (config == null) {
            config = Bitmap.Config.ARGB_8888;
        }
        return config;
    }

    public static final boolean isHardware(@NotNull Bitmap.Config $this$isHardware) {
        Intrinsics.checkNotNullParameter((Object)$this$isHardware, (String)"<this>");
        return Build.VERSION.SDK_INT >= 26 && $this$isHardware == Bitmap.Config.HARDWARE;
    }

    @NotNull
    public static final Bitmap.Config toBitmapConfig(@NotNull Options.ImageConfig $this$toBitmapConfig) {
        Bitmap.Config config;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toBitmapConfig), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toBitmapConfig.ordinal()]) {
            case 1: {
                config = Bitmap.Config.ALPHA_8;
                break;
            }
            case 2: {
                config = Bitmap.Config.ARGB_8888;
                break;
            }
            case 3: {
                if (Build.VERSION.SDK_INT >= 26) {
                    config = Bitmap.Config.RGBA_F16;
                    break;
                }
                Log.w((String)"ImageConfig", (String)"ImageConfig.RGBA_F16 not support in android less than API 26");
                config = Bitmap.Config.ARGB_8888;
                break;
            }
            case 4: {
                if (Build.VERSION.SDK_INT >= 26) {
                    config = Bitmap.Config.HARDWARE;
                    break;
                }
                Log.w((String)"ImageConfig", (String)"ImageConfig.HARDWARE not support in android less than API 26");
                config = Bitmap.Config.ARGB_8888;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return config;
    }

    @NotNull
    public static final Bitmap.Config toSoftware(@Nullable Bitmap.Config $this$toSoftware) {
        return $this$toSoftware == null || BitmapKt.isHardware($this$toSoftware) ? Bitmap.Config.ARGB_8888 : $this$toSoftware;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Options.ImageConfig.values().length];
            try {
                nArray[Options.ImageConfig.ALPHA_8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Options.ImageConfig.ARGB_8888.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Options.ImageConfig.RGBA_F16.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Options.ImageConfig.HARDWARE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

