/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.util;

import androidx.annotation.Px;
import com.seiko.imageloader.option.Scale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J8\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0005\u001a\u00020\f2\b\b\u0001\u0010\u0006\u001a\u00020\f2\b\b\u0001\u0010\u0007\u001a\u00020\f2\b\b\u0001\u0010\b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0007J8\u0010\u000b\u001a\u00020\r2\b\b\u0001\u0010\u0005\u001a\u00020\r2\b\b\u0001\u0010\u0006\u001a\u00020\r2\b\b\u0001\u0010\u0007\u001a\u00020\r2\b\b\u0001\u0010\b\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0007J8\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0005\u001a\u00020\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u00042\b\b\u0001\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/seiko/imageloader/util/DecodeUtils;", "", "()V", "calculateInSampleSize", "", "srcWidth", "srcHeight", "dstWidth", "dstHeight", "scale", "Lcom/seiko/imageloader/option/Scale;", "computeSizeMultiplier", "", "", "image-loader_debug"})
public final class DecodeUtils {
    @NotNull
    public static final DecodeUtils INSTANCE = new DecodeUtils();

    private DecodeUtils() {
    }

    @JvmStatic
    public static final int calculateInSampleSize(@Px int srcWidth, @Px int srcHeight, @Px int dstWidth, @Px int dstHeight, @NotNull Scale scale2) {
        Intrinsics.checkNotNullParameter((Object)((Object)scale2), (String)"scale");
        int widthInSampleSize = Integer.highestOneBit(srcWidth / dstWidth);
        int heightInSampleSize = Integer.highestOneBit(srcHeight / dstHeight);
        return RangesKt.coerceAtLeast((int)(WhenMappings.$EnumSwitchMapping$0[scale2.ordinal()] == 1 ? Math.min(widthInSampleSize, heightInSampleSize) : Math.max(widthInSampleSize, heightInSampleSize)), (int)1);
    }

    @JvmStatic
    public static final double computeSizeMultiplier(@Px int srcWidth, @Px int srcHeight, @Px int dstWidth, @Px int dstHeight, @NotNull Scale scale2) {
        Intrinsics.checkNotNullParameter((Object)((Object)scale2), (String)"scale");
        double widthPercent = (double)dstWidth / (double)srcWidth;
        double heightPercent = (double)dstHeight / (double)srcHeight;
        return WhenMappings.$EnumSwitchMapping$0[scale2.ordinal()] == 1 ? Math.max(widthPercent, heightPercent) : Math.min(widthPercent, heightPercent);
    }

    @JvmStatic
    public static final float computeSizeMultiplier(@Px float srcWidth, @Px float srcHeight, @Px float dstWidth, @Px float dstHeight, @NotNull Scale scale2) {
        Intrinsics.checkNotNullParameter((Object)((Object)scale2), (String)"scale");
        float widthPercent = dstWidth / srcWidth;
        float heightPercent = dstHeight / srcHeight;
        return WhenMappings.$EnumSwitchMapping$0[scale2.ordinal()] == 1 ? Math.max(widthPercent, heightPercent) : Math.min(widthPercent, heightPercent);
    }

    @JvmStatic
    public static final double computeSizeMultiplier(@Px double srcWidth, @Px double srcHeight, @Px double dstWidth, @Px double dstHeight, @NotNull Scale scale2) {
        Intrinsics.checkNotNullParameter((Object)((Object)scale2), (String)"scale");
        double widthPercent = dstWidth / srcWidth;
        double heightPercent = dstHeight / srcHeight;
        return WhenMappings.$EnumSwitchMapping$0[scale2.ordinal()] == 1 ? Math.max(widthPercent, heightPercent) : Math.min(widthPercent, heightPercent);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Scale.values().length];
            try {
                nArray[Scale.FILL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

