/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.WorkerThread;
import com.seiko.imageloader.option.Scale;
import com.seiko.imageloader.util.BitmapKt;
import com.seiko.imageloader.util.DecodeUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0004*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\u0004*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/seiko/imageloader/util/DrawableUtils;", "", "()V", "DEFAULT_SIZE", "", "height", "Landroid/graphics/drawable/Drawable;", "getHeight", "(Landroid/graphics/drawable/Drawable;)I", "width", "getWidth", "convertToBitmap", "Landroid/graphics/Bitmap;", "drawable", "config", "Landroid/graphics/Bitmap$Config;", "scale", "Lcom/seiko/imageloader/option/Scale;", "allowInexactSize", "", "isConfigValid", "bitmap", "isSizeValid", "image-loader_debug"})
@SourceDebugExtension(value={"SMAP\nDrawableUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DrawableUtils.kt\ncom/seiko/imageloader/util/DrawableUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n+ 4 Rect.kt\nandroidx/core/graphics/RectKt\n*L\n1#1,103:1\n1#2:104\n95#3:105\n38#4:106\n49#4:107\n60#4:108\n71#4:109\n*S KotlinDebug\n*F\n+ 1 DrawableUtils.kt\ncom/seiko/imageloader/util/DrawableUtils\n*L\n63#1:105\n65#1:106\n65#1:107\n65#1:108\n65#1:109\n*E\n"})
public final class DrawableUtils {
    @NotNull
    public static final DrawableUtils INSTANCE = new DrawableUtils();
    private static final int DEFAULT_SIZE = 512;

    private DrawableUtils() {
    }

    @WorkerThread
    @NotNull
    public final Bitmap convertToBitmap(@NotNull Drawable drawable, @NotNull Bitmap.Config config, @NotNull Scale scale2, boolean allowInexactSize) {
        Drawable drawable2;
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)scale2), (String)"scale");
        if (drawable instanceof BitmapDrawable) {
            Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
            if (this.isConfigValid(bitmap, config) && this.isSizeValid(allowInexactSize, bitmap, scale2)) {
                return bitmap;
            }
        }
        Drawable drawable3 = drawable.mutate();
        Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"drawable.mutate()");
        Drawable safeDrawable = drawable3;
        int it = this.getWidth(safeDrawable);
        boolean bl = false;
        int srcWidth = it > 0 ? it : 512;
        int it2 = this.getHeight(safeDrawable);
        boolean bl2 = false;
        int srcHeight = it2 > 0 ? it2 : 512;
        double multiplier = DecodeUtils.computeSizeMultiplier(srcWidth, srcHeight, srcWidth, srcHeight, scale2);
        int bitmapWidth = MathKt.roundToInt((double)(multiplier * (double)srcWidth));
        int bitmapHeight = MathKt.roundToInt((double)(multiplier * (double)srcHeight));
        Bitmap.Config config$iv = BitmapKt.toSoftware(config);
        boolean $i$f$createBitmap = false;
        Bitmap bitmap = Bitmap.createBitmap((int)bitmapWidth, (int)bitmapHeight, (Bitmap.Config)config$iv);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(width, height, config)");
        Bitmap bitmap2 = bitmap;
        Drawable $this$convertToBitmap_u24lambda_u242 = drawable2 = safeDrawable;
        boolean bl3 = false;
        Rect rect = $this$convertToBitmap_u24lambda_u242.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"bounds");
        Rect $this$component1$iv = rect;
        boolean $i$f$component1 = false;
        int oldLeft = $this$component1$iv.left;
        Rect $this$component2$iv = rect;
        boolean $i$f$component2 = false;
        int oldTop = $this$component2$iv.top;
        Rect $this$component3$iv = rect;
        boolean $i$f$component3 = false;
        int oldRight = $this$component3$iv.right;
        Rect $this$component4$iv = rect;
        boolean $i$f$component4 = false;
        int oldBottom = $this$component4$iv.bottom;
        $this$convertToBitmap_u24lambda_u242.setBounds(0, 0, bitmapWidth, bitmapHeight);
        $this$convertToBitmap_u24lambda_u242.draw(new Canvas(bitmap2));
        $this$convertToBitmap_u24lambda_u242.setBounds(oldLeft, oldTop, oldRight, oldBottom);
        return bitmap2;
    }

    private final boolean isConfigValid(Bitmap bitmap, Bitmap.Config config) {
        return bitmap.getConfig() == BitmapKt.toSoftware(config);
    }

    private final boolean isSizeValid(boolean allowInexactSize, Bitmap bitmap, Scale scale2) {
        return allowInexactSize ? true : DecodeUtils.computeSizeMultiplier(bitmap.getWidth(), bitmap.getHeight(), bitmap.getWidth(), bitmap.getHeight(), scale2) == 1.0;
    }

    private final int getWidth(Drawable $this$width) {
        BitmapDrawable bitmapDrawable = $this$width instanceof BitmapDrawable ? (BitmapDrawable)$this$width : null;
        return bitmapDrawable != null && (bitmapDrawable = bitmapDrawable.getBitmap()) != null ? bitmapDrawable.getWidth() : $this$width.getIntrinsicWidth();
    }

    private final int getHeight(Drawable $this$height) {
        BitmapDrawable bitmapDrawable = $this$height instanceof BitmapDrawable ? (BitmapDrawable)$this$height : null;
        return bitmapDrawable != null && (bitmapDrawable = bitmapDrawable.getBitmap()) != null ? bitmapDrawable.getHeight() : $this$height.getIntrinsicHeight();
    }
}

