/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import androidx.exifinterface.media.ExifInterface;
import com.seiko.imageloader.util.BitmapKt;
import com.seiko.imageloader.util.ExifData;
import com.seiko.imageloader.util.ExifInterfaceInputStream;
import com.seiko.imageloader.util.ExifUtilsKt;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/seiko/imageloader/util/ExifUtils;", "", "()V", "PAINT", "Landroid/graphics/Paint;", "SUPPORTED_MIME_TYPES", "", "", "[Ljava/lang/String;", "readData", "Lcom/seiko/imageloader/util/ExifData;", "mimeType", "source", "Lokio/BufferedSource;", "reverseTransformations", "Landroid/graphics/Bitmap;", "inBitmap", "exifData", "image-loader_debug"})
@SourceDebugExtension(value={"SMAP\nExifUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExifUtils.kt\ncom/seiko/imageloader/util/ExifUtils\n+ 2 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n*L\n1#1,123:1\n95#2:124\n95#2:125\n43#2,3:126\n*S KotlinDebug\n*F\n+ 1 ExifUtils.kt\ncom/seiko/imageloader/util/ExifUtils\n*L\n68#1:124\n70#1:125\n73#1:126,3\n*E\n"})
public final class ExifUtils {
    @NotNull
    public static final ExifUtils INSTANCE = new ExifUtils();
    @NotNull
    private static final String[] SUPPORTED_MIME_TYPES;
    @NotNull
    private static final Paint PAINT;

    private ExifUtils() {
    }

    @NotNull
    public final ExifData readData(@Nullable String mimeType, @NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (mimeType == null || !ArraysKt.contains((Object[])SUPPORTED_MIME_TYPES, (Object)mimeType)) {
            return ExifData.NONE;
        }
        ExifInterface exifInterface = new ExifInterface((InputStream)new ExifInterfaceInputStream(source.peek().inputStream()));
        return new ExifData(exifInterface.isFlipped(), exifInterface.getRotationDegrees());
    }

    @NotNull
    public final Bitmap reverseTransformations(@NotNull Bitmap inBitmap, @NotNull ExifData exifData) {
        Canvas c$iv;
        Bitmap outBitmap;
        Bitmap bitmap;
        int height$iv;
        int width$iv;
        boolean $i$f$createBitmap;
        Bitmap.Config config$iv;
        Intrinsics.checkNotNullParameter((Object)inBitmap, (String)"inBitmap");
        Intrinsics.checkNotNullParameter((Object)exifData, (String)"exifData");
        if (!exifData.isFlipped() && !ExifUtilsKt.isRotated(exifData)) {
            return inBitmap;
        }
        Matrix matrix = new Matrix();
        float centerX = (float)inBitmap.getWidth() / 2.0f;
        float centerY = (float)inBitmap.getHeight() / 2.0f;
        if (exifData.isFlipped()) {
            matrix.postScale(-1.0f, 1.0f, centerX, centerY);
        }
        if (ExifUtilsKt.isRotated(exifData)) {
            matrix.postRotate((float)exifData.getRotationDegrees(), centerX, centerY);
        }
        RectF rect = new RectF(0.0f, 0.0f, (float)inBitmap.getWidth(), (float)inBitmap.getHeight());
        matrix.mapRect(rect);
        if (!(rect.left == 0.0f) || !(rect.top == 0.0f)) {
            matrix.postTranslate(-rect.left, -rect.top);
        }
        if (ExifUtilsKt.isSwapped(exifData)) {
            int n = inBitmap.getHeight();
            int n2 = inBitmap.getWidth();
            config$iv = BitmapKt.getSafeConfig(inBitmap);
            $i$f$createBitmap = false;
            Bitmap bitmap2 = Bitmap.createBitmap((int)width$iv, (int)height$iv, (Bitmap.Config)config$iv);
            bitmap = bitmap2;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(width, height, config)");
        } else {
            width$iv = inBitmap.getWidth();
            height$iv = inBitmap.getHeight();
            config$iv = BitmapKt.getSafeConfig(inBitmap);
            $i$f$createBitmap = false;
            Bitmap bitmap3 = Bitmap.createBitmap((int)width$iv, (int)height$iv, (Bitmap.Config)config$iv);
            bitmap = bitmap3;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createBitmap(width, height, config)");
        }
        Bitmap $this$applyCanvas$iv = outBitmap = bitmap;
        boolean $i$f$applyCanvas = false;
        Canvas $this$reverseTransformations_u24lambda_u240 = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl = false;
        $this$reverseTransformations_u24lambda_u240.drawBitmap(inBitmap, matrix, PAINT);
        inBitmap.recycle();
        return outBitmap;
    }

    static {
        String[] stringArray = new String[]{"image/jpeg", "image/webp", "image/heic", "image/heif"};
        SUPPORTED_MIME_TYPES = stringArray;
        PAINT = new Paint(3);
    }
}

