/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.util;

import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import com.seiko.imageloader.util.LogPriority;
import com.seiko.imageloader.util.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b'\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\tR\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/seiko/imageloader/util/PlatformLogger;", "Lcom/seiko/imageloader/util/Logger;", "()V", "level", "", "Lcom/seiko/imageloader/util/LogPriority;", "getLevel", "(Lcom/seiko/imageloader/util/LogPriority;)I", "stackTraceString", "", "", "getStackTraceString", "(Ljava/lang/Throwable;)Ljava/lang/String;", "log", "", "priority", "tag", "throwable", "message", "Companion", "image-loader_debug"})
@StabilityInferred(parameters=0)
public abstract class PlatformLogger
implements Logger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    private static final int MAX_LOG_LENGTH = 4000;

    public final void log(@NotNull LogPriority priority, @NotNull String tag, @Nullable Throwable throwable, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String fullMessage = throwable != null ? message + "\n" + this.getStackTraceString(throwable) : message;
        int length = fullMessage.length();
        if (length <= 4000) {
            if (priority == LogPriority.ASSERT) {
                Log.wtf((String)tag, (String)fullMessage);
            } else {
                Log.println((int)this.getLevel(priority), (String)tag, (String)fullMessage);
            }
            return;
        }
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = StringsKt.indexOf$default((CharSequence)fullMessage, (char)'\n', (int)i, (boolean)false, (int)4, null);
            newline = newline != -1 ? newline : length;
            do {
                String part;
                end = Integer.min(newline, i + 4000);
                Intrinsics.checkNotNullExpressionValue((Object)fullMessage.substring(i, end), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                if (priority == LogPriority.ASSERT) {
                    Log.wtf((String)tag, (String)part);
                    continue;
                }
                Log.println((int)this.getLevel(priority), (String)tag, (String)part);
            } while ((i = end) < newline);
        }
    }

    private final String getStackTraceString(Throwable $this$stackTraceString) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        $this$stackTraceString.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        return string;
    }

    private final int getLevel(LogPriority $this$level) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$level.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                n = 7;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/seiko/imageloader/util/PlatformLogger$Companion;", "", "()V", "MAX_LOG_LENGTH", "", "image-loader_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogPriority.values().length];
            try {
                nArray[LogPriority.VERBOSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogPriority.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogPriority.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogPriority.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogPriority.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogPriority.ASSERT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

