/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a$\u0010\u0015\u001a\u00020\u0016*\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"GIF_HEADER_87A", "Lokio/ByteString;", "GIF_HEADER_89A", "HEIF_HEADER_FTYP", "HEIF_HEADER_HEVC", "HEIF_HEADER_HEVX", "HEIF_HEADER_MSF1", "LEFT_ANGLE_BRACKET", "SVG_TAG", "WEBP_HEADER_RIFF", "WEBP_HEADER_VPX8", "WEBP_HEADER_WEBP", "isAnimatedHeif", "", "source", "Lokio/BufferedSource;", "isAnimatedWebP", "isGif", "isHeif", "isSvg", "isWebP", "indexOf", "", "bytes", "fromIndex", "toIndex", "image-loader_debug"})
@SourceDebugExtension(value={"SMAP\nSourceType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceType.kt\ncom/seiko/imageloader/util/SourceTypeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class SourceTypeKt {
    @NotNull
    private static final ByteString LEFT_ANGLE_BRACKET = ByteString.Companion.encodeUtf8("<");
    @NotNull
    private static final ByteString SVG_TAG = ByteString.Companion.encodeUtf8("<svg");
    @NotNull
    private static final ByteString GIF_HEADER_87A = ByteString.Companion.encodeUtf8("GIF87a");
    @NotNull
    private static final ByteString GIF_HEADER_89A = ByteString.Companion.encodeUtf8("GIF89a");
    @NotNull
    private static final ByteString WEBP_HEADER_RIFF = ByteString.Companion.encodeUtf8("RIFF");
    @NotNull
    private static final ByteString WEBP_HEADER_WEBP = ByteString.Companion.encodeUtf8("WEBP");
    @NotNull
    private static final ByteString WEBP_HEADER_VPX8 = ByteString.Companion.encodeUtf8("VP8X");
    @NotNull
    private static final ByteString HEIF_HEADER_FTYP = ByteString.Companion.encodeUtf8("ftyp");
    @NotNull
    private static final ByteString HEIF_HEADER_MSF1 = ByteString.Companion.encodeUtf8("msf1");
    @NotNull
    private static final ByteString HEIF_HEADER_HEVC = ByteString.Companion.encodeUtf8("hevc");
    @NotNull
    private static final ByteString HEIF_HEADER_HEVX = ByteString.Companion.encodeUtf8("hevx");

    public static final boolean isSvg(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.rangeEquals(0L, LEFT_ANGLE_BRACKET) && SourceTypeKt.indexOf(source, SVG_TAG, 0L, 1024L) != -1L;
    }

    private static final long indexOf(BufferedSource $this$indexOf, ByteString bytes, long fromIndex, long toIndex) {
        if (!(bytes.size() > 0)) {
            boolean $i$a$-require-SourceTypeKt$indexOf$22 = false;
            String $i$a$-require-SourceTypeKt$indexOf$22 = "bytes is empty";
            throw new IllegalArgumentException($i$a$-require-SourceTypeKt$indexOf$22.toString());
        }
        byte firstByte = bytes.getByte(0);
        long lastIndex = toIndex - (long)bytes.size();
        long currentIndex = fromIndex;
        while (currentIndex < lastIndex) {
            if ((currentIndex = $this$indexOf.indexOf(firstByte, currentIndex, lastIndex)) == -1L || $this$indexOf.rangeEquals(currentIndex, bytes)) {
                return currentIndex;
            }
            long l = currentIndex;
            currentIndex = l + 1L;
        }
        return -1L;
    }

    public static final boolean isGif(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.rangeEquals(0L, GIF_HEADER_89A) || source.rangeEquals(0L, GIF_HEADER_87A);
    }

    public static final boolean isWebP(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.rangeEquals(0L, WEBP_HEADER_RIFF) && source.rangeEquals(8L, WEBP_HEADER_WEBP);
    }

    public static final boolean isAnimatedWebP(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return SourceTypeKt.isWebP(source) && source.rangeEquals(12L, WEBP_HEADER_VPX8) && source.request(17L) && (byte)(source.getBuffer().getByte(16L) & 2) > 0;
    }

    public static final boolean isHeif(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.rangeEquals(4L, HEIF_HEADER_FTYP);
    }

    public static final boolean isAnimatedHeif(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return SourceTypeKt.isHeif(source) && (source.rangeEquals(8L, HEIF_HEADER_MSF1) || source.rangeEquals(8L, HEIF_HEADER_HEVC) || source.rangeEquals(8L, HEIF_HEADER_HEVX));
    }
}

