/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader;

import android.content.Context;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidableCompositionLocal;
import com.seiko.imageloader.ImageLoader;
import com.seiko.imageloader.ImageLoaderConfigBuilder;
import com.seiko.imageloader.ImageLoaderKt;
import com.seiko.imageloader.ImageLoaderProvidableCompositionLocal;
import com.seiko.imageloader.cache.disk.DiskCacheBuilder;
import com.seiko.imageloader.cache.memory.MemoryCacheBuilder;
import com.seiko.imageloader.cache.memory.MemoryCacheBuilder_androidKt;
import com.seiko.imageloader.component.ComponentRegistryBuilder;
import com.seiko.imageloader.component.SetupDefaultComponents_androidKt;
import com.seiko.imageloader.intercept.InterceptorsBuilder;
import com.seiko.imageloader.intercept.InterceptorsExtKt;
import com.seiko.imageloader.option.OptionsBuilder;
import com.seiko.imageloader.option.Options_androidKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"createImageLoaderProvidableCompositionLocal", "Lcom/seiko/imageloader/ImageLoaderProvidableCompositionLocal;", "createDefaultAndroid", "Lcom/seiko/imageloader/ImageLoader;", "Lcom/seiko/imageloader/ImageLoader$Companion;", "context", "Landroid/content/Context;", "image-loader-singleton_release"})
public final class LocalImageLoader_androidKt {
    @NotNull
    public static final ImageLoaderProvidableCompositionLocal createImageLoaderProvidableCompositionLocal() {
        return new ImageLoaderProvidableCompositionLocal((ProvidableCompositionLocal<ImageLoader>)CompositionLocalKt.staticCompositionLocalOf(LocalImageLoader_androidKt::createImageLoaderProvidableCompositionLocal$lambda$0));
    }

    @NotNull
    public static final ImageLoader createDefaultAndroid(@NotNull ImageLoader.Companion $this$createDefaultAndroid, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$createDefaultAndroid, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ImageLoaderKt.ImageLoader$default(null, arg_0 -> LocalImageLoader_androidKt.createDefaultAndroid$lambda$8(context, arg_0), (int)1, null);
    }

    private static final ImageLoader createImageLoaderProvidableCompositionLocal$lambda$0() {
        return null;
    }

    private static final Unit createDefaultAndroid$lambda$8$lambda$1(Context $context, OptionsBuilder $this$options) {
        Intrinsics.checkNotNullParameter((Object)$this$options, (String)"$this$options");
        Context context = $context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
        Options_androidKt.androidContext((OptionsBuilder)$this$options, (Context)context);
        return Unit.INSTANCE;
    }

    private static final Unit createDefaultAndroid$lambda$8$lambda$2(ComponentRegistryBuilder $this$components) {
        Intrinsics.checkNotNullParameter((Object)$this$components, (String)"$this$components");
        SetupDefaultComponents_androidKt.setupDefaultComponents$default($this$components, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createDefaultAndroid$lambda$8$lambda$7$lambda$3(Context $context, MemoryCacheBuilder $this$bitmapMemoryCacheConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$bitmapMemoryCacheConfig, (String)"$this$bitmapMemoryCacheConfig");
        MemoryCacheBuilder_androidKt.maxSizePercent((MemoryCacheBuilder)$this$bitmapMemoryCacheConfig, (Context)$context, (double)0.25);
        return Unit.INSTANCE;
    }

    private static final Unit createDefaultAndroid$lambda$8$lambda$7$lambda$4(MemoryCacheBuilder $this$imageMemoryCacheConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$imageMemoryCacheConfig, (String)"$this$imageMemoryCacheConfig");
        $this$imageMemoryCacheConfig.maxSize(50);
        return Unit.INSTANCE;
    }

    private static final Unit createDefaultAndroid$lambda$8$lambda$7$lambda$5(MemoryCacheBuilder $this$painterMemoryCacheConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$painterMemoryCacheConfig, (String)"$this$painterMemoryCacheConfig");
        $this$painterMemoryCacheConfig.maxSize(50);
        return Unit.INSTANCE;
    }

    private static final Unit createDefaultAndroid$lambda$8$lambda$7$lambda$6(Context $context, DiskCacheBuilder $this$diskCacheConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$diskCacheConfig, (String)"$this$diskCacheConfig");
        File file = $context.getCacheDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCacheDir(...)");
        $this$diskCacheConfig.directory(Path.Companion.get$default((Path.Companion)Path.Companion, (File)FilesKt.resolve((File)file, (String)"image_cache"), (boolean)false, (int)1, null));
        $this$diskCacheConfig.maxSizeBytes(0x20000000L);
        return Unit.INSTANCE;
    }

    private static final Unit createDefaultAndroid$lambda$8$lambda$7(Context $context, InterceptorsBuilder $this$interceptor) {
        Intrinsics.checkNotNullParameter((Object)$this$interceptor, (String)"$this$interceptor");
        InterceptorsExtKt.bitmapMemoryCacheConfig$default((InterceptorsBuilder)$this$interceptor, null, null, arg_0 -> LocalImageLoader_androidKt.createDefaultAndroid$lambda$8$lambda$7$lambda$3($context, arg_0), (int)3, null);
        InterceptorsExtKt.imageMemoryCacheConfig$default((InterceptorsBuilder)$this$interceptor, null, null, LocalImageLoader_androidKt::createDefaultAndroid$lambda$8$lambda$7$lambda$4, (int)3, null);
        InterceptorsExtKt.painterMemoryCacheConfig$default((InterceptorsBuilder)$this$interceptor, null, null, LocalImageLoader_androidKt::createDefaultAndroid$lambda$8$lambda$7$lambda$5, (int)3, null);
        InterceptorsBuilder.diskCacheConfig$default((InterceptorsBuilder)$this$interceptor, null, arg_0 -> LocalImageLoader_androidKt.createDefaultAndroid$lambda$8$lambda$7$lambda$6($context, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createDefaultAndroid$lambda$8(Context $context, ImageLoaderConfigBuilder $this$ImageLoader) {
        Intrinsics.checkNotNullParameter((Object)$this$ImageLoader, (String)"$this$ImageLoader");
        $this$ImageLoader.options(arg_0 -> LocalImageLoader_androidKt.createDefaultAndroid$lambda$8$lambda$1($context, arg_0));
        $this$ImageLoader.components(LocalImageLoader_androidKt::createDefaultAndroid$lambda$8$lambda$2);
        $this$ImageLoader.interceptor(arg_0 -> LocalImageLoader_androidKt.createDefaultAndroid$lambda$8$lambda$7($context, arg_0));
        return Unit.INSTANCE;
    }
}

