/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.component.decoder;

import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.unit.Density;
import com.seiko.imageloader.component.decoder.DecodeResult;
import com.seiko.imageloader.component.decoder.Decoder;
import com.seiko.imageloader.component.decoder.SvgDecoder_androidKt;
import com.seiko.imageloader.model.ExtraDataKt;
import com.seiko.imageloader.model.ImageResult;
import com.seiko.imageloader.option.Options;
import com.seiko.imageloader.util.SourceTypeKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/seiko/imageloader/component/decoder/SvgDecoder;", "Lcom/seiko/imageloader/component/decoder/Decoder;", "source", "Lokio/BufferedSource;", "density", "Landroidx/compose/ui/unit/Density;", "options", "Lcom/seiko/imageloader/option/Options;", "<init>", "(Lokio/BufferedSource;Landroidx/compose/ui/unit/Density;Lcom/seiko/imageloader/option/Options;)V", "decode", "Lcom/seiko/imageloader/component/decoder/DecodeResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Factory", "Companion", "svg_debug"})
public final class SvgDecoder
implements Decoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final Density density;
    @NotNull
    private final Options options;
    @NotNull
    private static final String MIME_TYPE_SVG = "image/svg+xml";

    private SvgDecoder(BufferedSource source, Density density, Options options) {
        this.source = source;
        this.density = density;
        this.options = options;
    }

    @Nullable
    public Object decode(@NotNull Continuation<? super DecodeResult> $completion) {
        return new DecodeResult.OfPainter((Painter)SvgDecoder_androidKt.createSVGPainter(this.source, this.density, this.options));
    }

    public /* synthetic */ SvgDecoder(BufferedSource source, Density density, Options options, DefaultConstructorMarker $constructor_marker) {
        this(source, density, options);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/seiko/imageloader/component/decoder/SvgDecoder$Companion;", "", "<init>", "()V", "MIME_TYPE_SVG", "", "svg_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\u0010\b\u001a\u00060\nj\u0002`\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\u000e\u001a\u00020\u000f2\n\u0010\b\u001a\u00060\nj\u0002`\tH\u0002\u00a2\u0006\u0002\u0010\u0010R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/seiko/imageloader/component/decoder/SvgDecoder$Factory;", "Lcom/seiko/imageloader/component/decoder/Decoder$Factory;", "density", "Landroidx/compose/ui/unit/Density;", "<init>", "(Landroidx/compose/ui/unit/Density;)V", "create", "Lcom/seiko/imageloader/component/decoder/Decoder;", "source", "Lcom/seiko/imageloader/component/decoder/DecodeSource;", "Lcom/seiko/imageloader/model/ImageResult$OfSource;", "options", "Lcom/seiko/imageloader/option/Options;", "(Lcom/seiko/imageloader/model/ImageResult$OfSource;Lcom/seiko/imageloader/option/Options;)Lcom/seiko/imageloader/component/decoder/Decoder;", "isApplicable", "", "(Lcom/seiko/imageloader/model/ImageResult$OfSource;)Z", "svg_debug"})
    public static final class Factory
    implements Decoder.Factory {
        @Nullable
        private final Density density;

        public Factory(@Nullable Density density) {
            this.density = density;
        }

        public /* synthetic */ Factory(Density density, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                density = null;
            }
            this(density);
        }

        @Nullable
        public Decoder create(@NotNull ImageResult.OfSource source, @NotNull Options options) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            if (!this.isApplicable(source)) {
                return null;
            }
            BufferedSource bufferedSource = source.getSource();
            Density density = this.density;
            if (density == null) {
                density = SvgDecoder_androidKt.defaultDensity(options);
            }
            return new SvgDecoder(bufferedSource, density, options, null);
        }

        private final boolean isApplicable(ImageResult.OfSource source) {
            return Intrinsics.areEqual((Object)ExtraDataKt.getMimeType((Map)source.getExtra()), (Object)SvgDecoder.MIME_TYPE_SVG) || SourceTypeKt.isSvg((BufferedSource)source.getSource());
        }

        public Factory() {
            this(null, 1, null);
        }
    }
}

