/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.cfg.annotation.support;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.qiunet.cfg.annotation.Cfg;
import org.qiunet.cfg.annotation.CfgLoadOver;
import org.qiunet.cfg.base.ICfg;
import org.qiunet.cfg.event.CfgLoadCompleteEvent;
import org.qiunet.cfg.event.StartInitCfgEvent;
import org.qiunet.cfg.wrapper.CfgType;
import org.qiunet.cfg.wrapper.ICfgWrapper;
import org.qiunet.utils.args.ArgsContainer;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.listener.event.EventHandlerWeightType;
import org.qiunet.utils.listener.event.EventListener;
import org.qiunet.utils.reflect.ReflectUtil;
import org.qiunet.utils.scanner.IApplicationContext;
import org.qiunet.utils.scanner.IApplicationContextAware;
import org.qiunet.utils.scanner.ScannerType;
import org.qiunet.utils.scanner.anno.AutoWired;

enum CfgScannerManager implements IApplicationContextAware
{
    instance;

    private final List<LoadOverMethod> loadOverList = Lists.newArrayList();
    private IApplicationContext context;

    public void setApplicationContext(IApplicationContext context, ArgsContainer argsContainer) throws Exception {
        this.context = context;
        this.scannerLoadOverMethod();
        this.createCfgWrapper();
        this.cfgAutoWired();
        this.initCfg();
    }

    public ScannerType scannerType() {
        return ScannerType.CFG_SCANNER;
    }

    public int order() {
        return 10;
    }

    private void initCfg() {
        StartInitCfgEvent.instance.fireEventHandler();
    }

    private void scannerLoadOverMethod() {
        Set methods = this.context.getMethodsAnnotatedWith(CfgLoadOver.class);
        for (Method method : methods) {
            this.loadOverList.add(new LoadOverMethod(this.context.getInstanceOfClass(method.getDeclaringClass(), new Object[0]), method));
        }
    }

    private void createCfgWrapper() {
        Set classSet = this.context.getSubTypesOf(ICfg.class);
        for (Class aClass : classSet) {
            if (aClass.isInterface() || Modifier.isAbstract(aClass.getModifiers())) continue;
            if (!aClass.isAnnotationPresent(Cfg.class)) {
                throw new CustomException("Cfg class [{}] must specify Cfg Annotation!", new Object[]{aClass.getName()});
            }
            CfgType.createCfgWrapper(aClass);
        }
    }

    private void cfgAutoWired() throws Exception {
        Set fieldSet = this.context.getFieldsAnnotatedWith(AutoWired.class);
        for (Field field : fieldSet) {
            if (!ICfgWrapper.class.isAssignableFrom(field.getType())) continue;
            Type genericType = field.getGenericType();
            if (!ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
                throw new CustomException("ICfgWrapper must specify GenericType!", new Object[0]);
            }
            Object obj = null;
            if (!Modifier.isStatic(field.getModifiers())) {
                obj = this.context.getInstanceOfClass(field.getDeclaringClass(), new Object[0]);
            }
            Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
            Class cfgClass = (Class)types[types.length - 1];
            field.setAccessible(true);
            field.set(obj, CfgType.getCfgWrapper(cfgClass));
        }
    }

    @EventListener(value=EventHandlerWeightType.LESS)
    private void completeLoader(CfgLoadCompleteEvent data) {
        this.loadOverList.forEach(LoadOverMethod::call);
    }

    private static class LoadOverMethod {
        private final Object object;
        private final Method method;

        public LoadOverMethod(Object object, Method method) {
            this.object = object;
            this.method = method;
            if (method.getParameterCount() > 0) {
                throw new CustomException("LoadOver method not need parameter!", new Object[0]);
            }
            ReflectUtil.makeAccessible((Method)method);
        }

        public void call() {
            try {
                this.method.invoke(this.object, new Object[0]);
            }
            catch (Exception e) {
                throw new CustomException((Throwable)e, "load over method call error!", new Object[0]);
            }
        }
    }
}

