/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.cfg.manager;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.qiunet.cfg.event.CfgLoadCompleteEvent;
import org.qiunet.cfg.event.CfgManagerAddEvent;
import org.qiunet.cfg.event.StartInitCfgEvent;
import org.qiunet.cfg.manager.base.ICfgManager;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.listener.event.EventListener;
import org.qiunet.utils.logger.LoggerType;
import org.slf4j.Logger;

public enum CfgManagers {
    INSTANCE;

    private final Comparator<ICfgManager<?, ?>> comparator = (o1, o2) -> ComparisonChain.start().compare(o2.order(), o1.order()).result();
    private final List<ICfgManager<?, ?>> gameSettingList = Lists.newArrayListWithCapacity((int)100);
    private final Logger logger = LoggerType.DUODUO_CFG_READER.getLogger();
    private final AtomicBoolean reloading = new AtomicBoolean();

    public static CfgManagers getInstance() {
        return INSTANCE;
    }

    @EventListener
    private void initSetting(StartInitCfgEvent event) {
        this.gameSettingList.sort(this.comparator);
        this.reloadSetting(this.gameSettingList, false);
    }

    public synchronized void reloadSetting(List<ICfgManager<?, ?>> gameSettingList) {
        gameSettingList.sort(this.comparator);
        this.reloadSetting(gameSettingList, true);
    }

    public synchronized void reloadSetting() {
        this.reloadSetting(this.gameSettingList, true);
    }

    private synchronized void reloadSetting(List<ICfgManager<?, ?>> gameSettingList, boolean needLogger) {
        if (this.reloading.get()) {
            this.logger.error("Game Setting Data is loading now.....");
            return;
        }
        this.logger.error("Game Setting Data Load start.....");
        try {
            this.reloading.compareAndSet(false, true);
            this.loadDataSetting(gameSettingList);
        }
        catch (CustomException e) {
            if (needLogger) {
                e.logger(this.logger);
            }
            throw e;
        }
        finally {
            this.reloading.compareAndSet(true, false);
        }
        this.logger.error("Game Setting Data Load over.....");
        CfgLoadCompleteEvent.valueOf(gameSettingList).fireEventHandler();
    }

    public void addCfgManager(ICfgManager<?, ?> manager) {
        CfgManagerAddEvent.fireEvent(manager);
        this.gameSettingList.add(manager);
    }

    private synchronized void loadDataSetting(List<ICfgManager<?, ?>> gameSettingList) {
        for (ICfgManager<?, ?> cfgManager : gameSettingList) {
            try {
                cfgManager.loadCfg();
            }
            catch (Exception e) {
                throw new CustomException((Throwable)e, "\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6 [{}]({}) \u5931\u8d25!", new Object[]{cfgManager.getCfgClass().getSimpleName(), cfgManager.getLoadFileName()});
            }
            this.logger.info("Load Config [{}]({})", (Object)cfgManager.getCfgClass().getSimpleName(), (Object)cfgManager.getLoadFileName());
        }
    }
}

