/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.cfg.manager.base;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.qiunet.cfg.annotation.Cfg;
import org.qiunet.cfg.base.ICfg;
import org.qiunet.cfg.manager.CfgManagers;
import org.qiunet.cfg.manager.base.ICfgManager;
import org.qiunet.cfg.manager.exception.UnknownFieldException;
import org.qiunet.utils.convert.ConvertManager;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.file.FileUtil;
import org.qiunet.utils.logger.LoggerType;
import org.qiunet.utils.reflect.ReflectUtil;
import org.qiunet.utils.system.SystemPropertyUtil;
import org.qiunet.utils.timer.TimerManager;
import org.slf4j.Logger;

public abstract class BaseCfgManager<ID, Cfg extends ICfg<ID>>
implements ICfgManager<ID, Cfg> {
    protected Logger logger = LoggerType.DUODUO_CFG_READER.getLogger();
    private static final Set<ICfgManager<?, ?>> needReloadCfgs = Sets.newConcurrentHashSet();
    private static final AtomicBoolean needReloadCfg = new AtomicBoolean(false);
    protected String fileName;
    protected Class<Cfg> cfgClass;
    private final int order;

    protected void afterLoad() throws Exception {
    }

    protected void fileChangeListener(File file) {
        if (SystemPropertyUtil.getOsName().is(SystemPropertyUtil.OSType.LINUX)) {
            return;
        }
        FileUtil.changeListener((File)file, file1 -> {
            LoggerType.DUODUO_CFG_READER.debug("Cfg file [{}] changing", new Object[]{file1.getPath()});
            BaseCfgManager baseCfgManager = this;
            synchronized (baseCfgManager) {
                needReloadCfgs.add(this);
            }
            if (needReloadCfg.compareAndSet(false, true)) {
                TimerManager.instance.scheduleWithDelay(() -> {
                    try {
                        this.handlerReload();
                    }
                    finally {
                        needReloadCfgs.clear();
                    }
                    return null;
                }, 2L, TimeUnit.SECONDS);
            }
        });
    }

    private synchronized void handlerReload() {
        if (needReloadCfg.compareAndSet(true, false)) {
            LoggerType.DUODUO_CFG_READER.error("=======================\u6587\u4ef6\u70ed\u52a0\u8f7d\u5f00\u59cb=======================");
            CfgManagers.getInstance().reloadSetting(Lists.newArrayList(needReloadCfgs));
            LoggerType.DUODUO_CFG_READER.error("=======================\u6587\u4ef6\u70ed\u52a0\u8f7d\u7ed3\u675f=======================");
        }
    }

    @Override
    public String getLoadFileName() {
        return this.fileName;
    }

    @Override
    public Class<Cfg> getCfgClass() {
        return this.cfgClass;
    }

    public BaseCfgManager(Class<Cfg> cfgClass) {
        Cfg cfg = cfgClass.getAnnotation(Cfg.class);
        this.fileName = cfg.value();
        this.cfgClass = cfgClass;
        this.order = cfg.order();
        this.checkCfgClass(cfgClass);
        CfgManagers.getInstance().addCfgManager(this);
    }

    @Override
    public int order() {
        return this.order;
    }

    private void checkCfgClass(Class cfgClass) {
        for (Field field : cfgClass.getDeclaredFields()) {
            if (this.isInvalidField(field)) continue;
            boolean haveMethod = true;
            try {
                this.getSetMethod(cfgClass, field);
            }
            catch (NoSuchMethodException e) {
                haveMethod = false;
            }
            if (!haveMethod) continue;
            throw new CustomException("Cfg [" + cfgClass.getName() + "] field [" + field.getName() + "] can not define set method", new Object[0]);
        }
    }

    private boolean isInvalidField(Field field) {
        return Modifier.isPublic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers());
    }

    private Method getSetMethod(Class cfgClass, Field field) throws NoSuchMethodException {
        char[] chars = ("set" + field.getName()).toCharArray();
        chars[3] = (char)(chars[3] - 32);
        String methodName = new String(chars);
        return cfgClass.getMethod(methodName, field.getType());
    }

    protected <Cfg extends ICfg> void handlerObjConvertAndAssign(Cfg cfg, String name, String val) {
        Field field = ReflectUtil.findField(this.cfgClass, (String)name);
        if (field == null) {
            throw new UnknownFieldException(this.cfgClass.getName(), this.fileName, name);
        }
        if (this.isInvalidField(field)) {
            throw new CustomException("Class [" + cfg.getClass().getName() + "] field [" + field.getName() + "] is invalid!", new Object[0]);
        }
        Object obj = ConvertManager.getInstance().convert(field, val);
        ReflectUtil.setField(cfg, (Field)field, (Object)obj);
    }
}

