/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.cfg.manager.exception;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.qiunet.utils.exceptions.CustomException;

public class UnknownFieldException
extends CustomException {
    private static final String SEPARATOR = "\n-------------------------------";
    private final Map<String, Object> stuff = new LinkedHashMap<String, Object>();

    public UnknownFieldException(String type, String cfgFile, String field) {
        super("No such field {} in cfg class {}", new Object[]{field, type});
        this.add("cfgFile", cfgFile);
        this.add("cfgClass", type);
        this.add("field", field);
    }

    public UnknownFieldException(String message, Object ... params) {
        super(message, params);
    }

    private void addData(String msg, Throwable cause) {
        if (msg != null) {
            this.add("message", msg);
        }
        if (cause != null) {
            this.add("cause-exception", cause.getClass().getName());
            this.add("cause-message", cause.getMessage());
        }
    }

    public String get(String errorKey) {
        return (String)this.stuff.get(errorKey);
    }

    public void add(String name, String information) {
        Object key = name;
        int i = 0;
        while (this.stuff.containsKey(key)) {
            String value = (String)this.stuff.get(key);
            if (information.equals(value)) {
                return;
            }
            key = name + "[" + ++i + "]";
        }
        this.stuff.put((String)key, information);
    }

    public void set(String name, String information) {
        Object key = name;
        int i = 0;
        this.stuff.put((String)key, information);
        while (this.stuff.containsKey(key)) {
            if (i != 0) {
                this.stuff.remove(key);
            }
            key = name + "[" + ++i + "]";
        }
    }

    public Iterator keys() {
        return this.stuff.keySet().iterator();
    }

    public String getMessage() {
        StringBuffer result = new StringBuffer();
        if (super.getMessage() != null) {
            result.append(super.getMessage());
        }
        if (!result.toString().endsWith(SEPARATOR)) {
            result.append("\n---- Debugging information ----");
        }
        Iterator iterator = this.keys();
        while (iterator.hasNext()) {
            String k = (String)iterator.next();
            String v = this.get(k);
            result.append('\n').append(k);
            result.append("                    ".substring(Math.min(20, k.length())));
            result.append(": ").append(v);
        }
        result.append(SEPARATOR);
        return result.toString();
    }
}

