/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.cfg.manager.json;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.qiunet.cfg.base.ICfg;
import org.qiunet.cfg.manager.base.BaseCfgManager;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.file.DPath;
import org.qiunet.utils.file.FileUtil;
import org.qiunet.utils.json.JsonUtil;
import org.qiunet.utils.logger.LoggerType;
import org.qiunet.utils.string.StringUtil;

abstract class BaseJsonCfgManager<ID, Cfg extends ICfg<ID>>
extends BaseCfgManager<ID, Cfg> {
    protected List<Cfg> cfgList;

    BaseJsonCfgManager(Class<Cfg> cfgClass) {
        super(cfgClass);
    }

    @Override
    public void loadCfg() throws Exception {
        this.cfgList = this.getSimpleListCfg();
        this.init();
        this.afterLoad();
    }

    abstract void init() throws Exception;

    public List<Cfg> list() {
        return this.cfgList;
    }

    private File[] getFile(String fileName) {
        if (fileName.contains("*")) {
            LinkedList files = Lists.newLinkedList();
            String dirName = Objects.requireNonNull(this.getClass().getClassLoader().getResource(DPath.dirName((String)fileName))).getFile();
            String finalFileName = DPath.fileName((String)fileName).replaceAll("\\.", "\\\\.").replaceAll("\\*", "(.*)");
            DPath.listDir((String)dirName, files::add, file -> file.getName().matches(finalFileName));
            return files.toArray(new File[0]);
        }
        String filePath = Objects.requireNonNull(this.getClass().getClassLoader().getResource(fileName)).getFile();
        return new File[]{new File(filePath)};
    }

    private List<Cfg> getSimpleListCfg() {
        File[] files;
        this.logger.debug("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6 [ " + this.fileName + " ]");
        LinkedList jsonObjects = Lists.newLinkedList();
        for (File file : files = this.getFile(this.fileName)) {
            String json;
            this.fileChangeListener(file);
            try {
                json = FileUtil.getFileContent((File)file);
                if (StringUtil.isEmpty((String)json)) {
                    this.logger.debug("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6 [{}] content is null!", (Object)file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new CustomException((Throwable)e, "\u8bfb\u53d6[{}]\u5f02\u5e38!", new Object[]{file.getAbsolutePath()});
            }
            List generalList = JsonUtil.getGeneralList((String)json, JSONObject.class);
            if (generalList == null) {
                throw new NullPointerException("FileName [" + file.getAbsolutePath() + "] is not JsonList!");
            }
            jsonObjects.addAll(generalList);
        }
        return jsonObjects.stream().map(this::generalCfg).collect(Collectors.toList());
    }

    protected Cfg generalCfg(JSONObject jsonObject) {
        ICfg cfg = null;
        try {
            cfg = (ICfg)this.cfgClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LoggerType.DUODUO_CFG_READER.error("generalCfg", (Throwable)e);
        }
        ICfg finalCfg = cfg;
        Preconditions.checkNotNull((Object)cfg);
        jsonObject.forEach((key, val) -> this.handlerObjConvertAndAssign(finalCfg, (String)key, String.valueOf(val)));
        return (Cfg)cfg;
    }
}

