/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.cfg.manager.json;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.qiunet.cfg.base.INeedInitCfg;
import org.qiunet.cfg.base.INestListCfg;
import org.qiunet.cfg.base.ISortable;
import org.qiunet.cfg.manager.base.INestListCfgManager;
import org.qiunet.cfg.manager.json.BaseJsonCfgManager;
import org.qiunet.utils.collection.safe.SafeList;
import org.qiunet.utils.collection.safe.SafeMap;

public class NestListJsonCfgManager<ID, Cfg extends INestListCfg<ID>>
extends BaseJsonCfgManager<ID, Cfg>
implements INestListCfgManager<ID, Cfg> {
    private Map<ID, List<Cfg>> cfgMap;

    public NestListJsonCfgManager(Class<Cfg> cfgClass) {
        super(cfgClass);
    }

    @Override
    void init() throws Exception {
        this.cfgMap = this.getNestListCfg();
        this.initCfgSelf();
    }

    private void initCfgSelf() {
        if (!INeedInitCfg.class.isAssignableFrom(this.getCfgClass())) {
            return;
        }
        this.cfgMap.values().stream().flatMap(Collection::stream).map(cfg -> (INeedInitCfg)((Object)cfg)).forEach(INeedInitCfg::init);
    }

    protected Map<ID, List<Cfg>> getNestListCfg() throws Exception {
        SafeMap cfgMap = new SafeMap();
        for (INestListCfg cfg : this.cfgList) {
            List subList = (List)cfgMap.computeIfAbsent(cfg.getId(), key -> new SafeList());
            subList.add(cfg);
        }
        for (List cfgList : cfgMap.values()) {
            if (ISortable.class.isAssignableFrom(this.getCfgClass())) {
                Collections.sort(this.cfgList);
            }
            ((SafeList)cfgList).convertToUnmodifiable();
        }
        cfgMap.loggerIfAbsent();
        cfgMap.convertToUnmodifiable();
        return cfgMap;
    }

    @Override
    public Map<ID, List<Cfg>> allCfgs() {
        return this.cfgMap;
    }
}

