/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.cfg.manager.json;

import java.util.Map;
import org.qiunet.cfg.base.INeedInitCfg;
import org.qiunet.cfg.base.INestMapCfg;
import org.qiunet.cfg.manager.base.INestMapCfgManager;
import org.qiunet.cfg.manager.json.BaseJsonCfgManager;
import org.qiunet.utils.collection.safe.SafeMap;

public class NestMapJsonCfgManager<ID, SubId, Cfg extends INestMapCfg<ID, SubId>>
extends BaseJsonCfgManager<ID, Cfg>
implements INestMapCfgManager<ID, SubId, Cfg> {
    private Map<ID, Map<SubId, Cfg>> cfgs;

    public NestMapJsonCfgManager(Class<Cfg> cfgClass) {
        super(cfgClass);
    }

    @Override
    void init() throws Exception {
        this.cfgs = this.getNestMapCfg();
        this.initCfgSelf();
    }

    private void initCfgSelf() {
        if (!INeedInitCfg.class.isAssignableFrom(this.getCfgClass())) {
            return;
        }
        this.cfgs.values().stream().flatMap(val -> val.values().stream()).map(cfg -> (INeedInitCfg)((Object)cfg)).forEach(INeedInitCfg::init);
    }

    public Cfg getCfgByIdAndSubId(ID id, SubId subId) {
        Map<SubId, Cfg> subIdCfgMap = this.cfgs.get(id);
        if (subIdCfgMap == null) {
            return null;
        }
        return (Cfg)((INestMapCfg)subIdCfgMap.get(subId));
    }

    protected Map<ID, Map<SubId, Cfg>> getNestMapCfg() throws Exception {
        SafeMap cfgMap = new SafeMap();
        for (INestMapCfg cfg : this.cfgList) {
            Map subMap = (Map)cfgMap.computeIfAbsent(cfg.getId(), key -> new SafeMap());
            subMap.put(cfg.getSubId(), cfg);
        }
        for (Map subKeyCfgMap : cfgMap.values()) {
            ((SafeMap)subKeyCfgMap).loggerIfAbsent();
            ((SafeMap)subKeyCfgMap).convertToUnmodifiable();
        }
        cfgMap.loggerIfAbsent();
        cfgMap.convertToUnmodifiable();
        return cfgMap;
    }

    @Override
    public Map<ID, Map<SubId, Cfg>> allCfgs() {
        return this.cfgs;
    }
}

